from typing import Optional
import os
from .imagelist import PklImageListMetaworld

class MetaworldLoader(PklImageListMetaworld):
    objnav_data_dict = {
        "FOV": "train_dataset.pkl",
        #"STEPSIZE": "train_dataset.pkl",
        #"ROTATE": "train_dataset.pkl",
    }
    CLASSES = ['Robot']

    def __init__(self, root: str, task: str = "pair", download: Optional[bool] = False, **kwargs):
        image_file_list = list(self.objnav_data_dict.items())
        data_file_list = [os.path.join(root, factor, image_file) for factor, image_file in image_file_list]
        
        super(MetaworldLoader, self).__init__(root, MetaworldLoader.CLASSES, data_file_list=data_file_list, **kwargs)

    @classmethod
    def domains(cls):
        return list(cls.objnav_data_dict.keys())