import torch.nn as nn
from typing import Sequence, Union

from allenact.base_abstractions.preprocessor import Preprocessor
from allenact.utils.experiment_utils import Builder, TrainingPipeline
from allenact_plugins.clip_plugin.clip_preprocessors import (
    ClipViTPreprocessor,
    NaivePreprocessor
)
from projects.plugins.ithor_plugin.ithor_sensors import RGBSensorThor
from projects.plugins.robothor_plugin.robothor_sensors import GPSCompassSensorRoboThor
from projects.point_navigation.baseline_configs.mixins import (
    VAEPreprocessGRUActorCriticMixin,
)
from projects.point_navigation.baseline_configs.ithor.pointnav_ithor_base import (
    PointNaviThorAUTOTESTBaseConfig
)
from projects.point_navigation.baseline_configs.mixins import PointNavPPOMixin


class ObjectNaviThorClipViTRGBPPOExperimentConfig(PointNaviThorAUTOTESTBaseConfig):
    """A CLIP Object Navigation experiment configuration in RoboThor
    with RGB input."""

    CLIP_MODEL_TYPE = "ViT-B/32"

    SENSORS = [
        RGBSensorThor(
            height=PointNaviThorAUTOTESTBaseConfig.SCREEN_SIZE,
            width=PointNaviThorAUTOTESTBaseConfig.SCREEN_SIZE,
            use_resnet_normalization=True,
            mean=ClipViTPreprocessor.CLIP_RGB_MEANS,
            stdev=ClipViTPreprocessor.CLIP_RGB_STDS,
            uuid="rgb_lowres",
        ),
        GPSCompassSensorRoboThor(),
    ]
    
    SOURCE_MODEL = '/path/to/MMRL/LUSR/checkpoints/domain_factor/model_200_ithor_cnn.pt'

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        
        self.DATA_GEN = False

        # self.preprocessing_and_model = ZeroshotClipViTPreprocessGRUActorCriticMixin(
        #     sensors=self.SENSORS,
        #     clip_model_type=self.CLIP_MODEL_TYPE,
        #     screen_size=self.SCREEN_SIZE,
        #     goal_sensor_type=GPSCompassSensorRoboThor,
        #     pool=False,
        #     pooling_type='',
        #     target_types=self.TARGET_TYPES,
        #     prompt = self.PROMPT,
        #     noise_std = self.NOISE_STD,
        # )
        self.preprocessing_and_model = VAEPreprocessGRUActorCriticMixin(
            sensors=self.SENSORS,
            clip_model_type=self.CLIP_MODEL_TYPE,
            screen_size=self.SCREEN_SIZE,
            goal_sensor_type=GPSCompassSensorRoboThor,
            pool=False,
            pooling_type='',
            target_types=self.TARGET_TYPES,
            source_model=self.SOURCE_MODEL
        )

    def training_pipeline(self, **kwargs) -> TrainingPipeline:
        return PointNavPPOMixin.training_pipeline(
            auxiliary_uuids=[],
            multiple_beliefs=False,
            normalize_advantage=True,
            advance_scene_rollout_period=self.ADVANCE_SCENE_ROLLOUT_PERIOD,
        )

    def preprocessors(self) -> Sequence[Union[Preprocessor, Builder[Preprocessor]]]:
        return self.preprocessing_and_model.preprocessors()

    def create_model(self, **kwargs) -> nn.Module:
        return self.preprocessing_and_model.create_model(
            num_actions=self.ACTION_SPACE.n, **kwargs
        )

    def tag(cls):
        return "pointnav_ithor_rgb_lusrgru_ddppo_autotest"
# file name: pointnav_ithor_rgb_lusrgru_ddppo_autotest
