from baseline_configs.one_phase.one_phase_rgb_il_base import (
    OnePhaseRGBILBaseExperimentConfig,
)


class OnePhaseRGBClipResNet50DaggerExperimentConfig(OnePhaseRGBILBaseExperimentConfig):
    CNN_PREPROCESSOR_TYPE_AND_PRETRAINING = ("ViT-B/32", "clip")
    IL_PIPELINE_TYPE = "40proc"
    
    MODEL="attempt" # attempt, sesom
    NOISE_STD = 0.0
    PROMPT = (
        "/path/to/MMRL/logs/PROMPTS/BRIGHTNESS/checkpoints/contrastive__latest.pth",
        "/path/to/MMRL/logs/PROMPTS/CONTRAST/checkpoints/contrastive__latest.pth",
        "/path/to/MMRL/logs/PROMPTS/SATURATION/checkpoints/contrastive__latest.pth",
        "/path/to/MMRL/logs/PROMPTS/HUE/checkpoints/contrastive__latest.pth",
        
        "/path/to/MMRL/logs/PROMPTS/FOV_39-59/checkpoints/comparative_action_byol_latest.pth",
        "/path/to/MMRL/logs/PROMPTS/FOV_69-89/checkpoints/comparative_action_byol_latest.pth",
        "/path/to/MMRL/logs/PROMPTS/FOV_99-139/checkpoints/comparative_action_byol_latest.pth",

        "/path/to/MMRL/logs/PROMPTS/LOOK/checkpoints/comparative_action_byol_latest.pth",
        "/path/to/MMRL/logs/PROMPTS/ROTATE/checkpoints/comparative_action_byol_latest.pth",
        "/path/to/MMRL/logs/PROMPTS/STEPSIZE/checkpoints/comparative_action_byol_latest.pth",
    )

    MULTI_P_MODE = [
        ("ATTEMPT","WEIGHTED", "AVG"),
        ("SESoM","WEIGHTED", "AVG"),
        ]
    META_MODE = True
    SOURCE_MODEL=(
        None,
        "/path/to/MMRL/allenact/projects/ithor_rearrangement/rearrange_out/MAIN-EXP/REARRANGE/checkpoints/OnePhaseRGBTaskClipViT32Dagger_40proc_Noise002/2023-05-06_11-33-52/exp_OnePhaseRGBTaskClipViT32Dagger_40proc_Noise002__stage_00__steps_000000140672.pt"
    )

    STEP_SIZE =             [0.1, 0.15]

    @classmethod
    def tag(cls) -> str:
        return f"OnePhaseRGBTaskClipViT32Dagger_{cls.IL_PIPELINE_TYPE}_Noise002"
