from baseline_configs.one_phase.one_phase_rgb_il_base import (
    OnePhaseRGBILBaseExperimentConfig,
)


class OnePhaseRGBClipResNet50DaggerExperimentConfig(OnePhaseRGBILBaseExperimentConfig):
    CNN_PREPROCESSOR_TYPE_AND_PRETRAINING = ("ViT-B/32", "clip")
    IL_PIPELINE_TYPE = "40proc"
    
    MODEL="conpe"
    NOISE_STD = 0.0
    PROMPT = (
        "/path/to/MMRL/logs/PROMPTS/BRIGHTNESS/checkpoints/contrastive__latest.pth",
        "/path/to/MMRL/logs/PROMPTS/CONTRAST/checkpoints/contrastive__latest.pth",
        "/path/to/MMRL/logs/PROMPTS/SATURATION/checkpoints/contrastive__latest.pth",
        "/path/to/MMRL/logs/PROMPTS/HUE/checkpoints/contrastive__latest.pth",
        
        "/path/to/MMRL/logs/PROMPTS/FOV_39-59/checkpoints/comparative_action_byol_latest.pth",
        "/path/to/MMRL/logs/PROMPTS/FOV_69-89/checkpoints/comparative_action_byol_latest.pth",
        "/path/to/MMRL/logs/PROMPTS/FOV_99-139/checkpoints/comparative_action_byol_latest.pth",

        "/path/to/MMRL/logs/PROMPTS/LOOK/checkpoints/comparative_action_byol_latest.pth",
        "/path/to/MMRL/logs/PROMPTS/ROTATE/checkpoints/comparative_action_byol_latest.pth",
        "/path/to/MMRL/logs/PROMPTS/STEPSIZE/checkpoints/comparative_action_byol_latest.pth",
    )

    MULTI_P_MODE = [
        ("COMPOSE", "UNIFORM", "AVG"), 
        ("COMPOSE", "UNIFORM", "CAT"), 
        ("COMPOSE", "WEIGHTED", "AVG"), 
        ("COMPOSE", "WEIGHTED", "CAT"), 
        ("ENSEMBLE", "UNIFORM", "AVG"), 
        ("ENSEMBLE", "UNIFORM", "CAT"), 
        ("ENSEMBLE", "WEIGHTED", "AVG"), 
        ("ENSEMBLE", "WEIGHTED", "CAT"), 
        ("ATTEMPT","WEIGHTED", "AVG"),
        ("SESoM","WEIGHTED", "AVG"),
        ]
    META_MODE = True
    SOURCE_MODEL=(
        None,
        "/path/to/MMRL/allenact/projects/ithor_rearrangement/rearrange_out/MAIN-EXP/REARRANGE/checkpoints/OnePhaseRGBTaskClipViT32Dagger_40proc_Noise002/2023-05-06_11-33-52/exp_OnePhaseRGBTaskClipViT32Dagger_40proc_Noise002__stage_00__steps_000000140672.pt"
    )

    STEP_SIZE =             [0.1, 0.15]
    # ROTATION_DEGREES =      [90.0, 60.0, 30.0, 10.0]
    # VISIBILITY_DISTANCE =   [1.0 , 1.0, 1.0, 1.0]
    # LIGHTING_VALUE =        [(0.6, 0.2, 1.5, -0.4), (1.1, 1.0, 0.5, -0.1), None, (2.0, 3.5, 2, 0.4)]
    # HORIZONTAL_FIELD_OF_VIEW = [59, 69, 79, 99]
    # LOOK_DEGREES = [40, 10, 30, 20]

    @classmethod
    def tag(cls) -> str:
        return f"OnePhaseRGBTaskClipViT32Dagger_{cls.IL_PIPELINE_TYPE}_Noise002"
