

from typing import List
import random
import string

def gen_input(max_n: int, max_k: int) -> str:
    n = random.randint(1, max_n)
    k = random.randint(1, min(n, max_k))
    labels = ''.join((random.choice(string.ascii_lowercase) for _ in range(n)))
    nodes = list(range(n))
    random.shuffle(nodes)
    children = [(0, 0) for _ in range(n)]
    for i in range(1, n):
        parent = nodes[random.randint(0, i - 1)]
        (left_child, right_child) = children[parent]
        if left_child == 0:
            children[parent] = (nodes[i], right_child)
        else:
            children[parent] = (left_child, nodes[i])
    children_str = '\n'.join((f'{left} {right}' for (left, right) in children))
    input_str = f'{n} {k}\n{labels}\n{children_str}'
    return input_str

def batch_gen_inputs(batch_size,) -> List[str]:
    inputs = [gen_input(10, 5) for _ in range(batch_size)]
    return inputs
