import random
import string


def gen_input(n: int, max_len: int) -> str:
    strings = []
    for _ in range(n):
        length = random.randint(1, max_len)
        s = ''.join(sorted(random.choices(string.ascii_lowercase, k=length)))
        strings.append(s)
    return '{}\n{}'.format(n, '\n'.join(strings))

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        n = random.randint(1, 5)
        max_len = random.randint(1, 10)
        inputs.append(gen_input(n, max_len))
    return inputs
