# TEST_RESULT: True

def solution(stdin: str) -> str:
    from typing import List
    from collections import Counter
    from math import gcd

    def factors(n: int) -> List[int]:
        i = 1
        factors = []
        while i * i <= n:
            if n % i:
                i += 1
                continue
            yield i
            if n // i != i:
                yield (n // i)
            i += 1

    def can_be_colored(arr: List[int], d: int) -> bool:
        colors = [i % d == 0 for i in arr]
        for i in range(1, len(colors)):
            if colors[i] == colors[i - 1]:
                return False
        return True
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    tests = [(int(lines[i]), list(map(int, lines[i + 1].split()))) for i in range(1, 2 * t + 1, 2)]
    res = []
    for (n, arr) in tests:
        counter = Counter(arr)
        sorted_arr = sorted(counter.keys())
        d = 0
        for num in sorted_arr:
            for factor in factors(num):
                if can_be_colored(arr, factor):
                    d = factor
                    break
            if d != 0:
                break
        res.append(str(d))
    return '\n'.join(res)
