# TEST_RESULT: True
from itertools import product


def generate_states(memory):
    options = [['0', '1'] if m == '?' else [m] for m in memory]
    return [''.join(opt) for opt in product(*options)]

def calculate_time(start, end):
    time = 0
    for i in range(len(start) - 1):
        if start[i:i + 2] != end[i:i + 2]:
            time += 1
    return time

def solution(stdin: str) -> str:
    MOD = 10 ** 9 + 7
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    lines = lines[1:]
    results = []
    for i in range(t):
        n = int(lines[i * 3])
        start_memory = lines[i * 3 + 1]
        end_memory = lines[i * 3 + 2]
        start_states = generate_states(start_memory)
        end_states = generate_states(end_memory)
        total_time = 0
        for start in start_states:
            for end in end_states:
                total_time += calculate_time(start, end)
        results.append(str(total_time % MOD))
    return '\n'.join(results)
