# TEST_RESULT: True
from itertools import combinations

def get_mex(seq):
    """Compute the MEX of a sequence."""
    mex = 0
    while mex in seq:
        mex += 1
    return mex

def is_mex_correct(subseq):
    """Check if a subsequence is MEX-correct."""
    for i in range(len(subseq)):
        mex = get_mex(subseq[:i + 1])
        if abs(subseq[i] - mex) > 1:
            return False
    return True

def count_mex_correct_subsequences(a):
    """Count the number of MEX-correct subsequences of an array."""
    MOD = 998244353
    count = 0
    for length in range(1, len(a) + 1):
        for subseq in combinations(a, length):
            if is_mex_correct(list(subseq)):
                count += 1
    return count % MOD

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    outputs = []
    for i in range(t):
        n = int(lines[i * 2 + 1])
        a = list(map(int, lines[i * 2 + 2].split()))
        outputs.append(count_mex_correct_subsequences(a))
    return '\n'.join((str(output) for output in outputs))
