# TEST_RESULT: False
from collections import defaultdict
from typing import List, Dict

from collections import defaultdict
from typing import List, Dict, Tuple

def parse_input(input_str: str) -> Tuple:
    lines = input_str.strip().split('\n')
    (n, m, q) = map(int, lines[0].split())
    edges = []
    for i in range(1, n):
        (u, v, c) = lines[i].split()
        edges.append((int(u), int(v), c))
    strings = lines[n:n + m]
    queries = []
    for i in range(n + m, n + m + q):
        (u, v, l, r) = map(int, lines[i].split())
        queries.append((u, v, l - 1, r - 1))
    return (n, m, q, edges, strings, queries)

def build_tree(n: int, edges: List[Tuple[int, int, str]]) -> Dict[int, Dict[int, str]]:
    tree = defaultdict(dict)
    for (u, v, c) in edges:
        tree[u][v] = c
        tree[v][u] = c
    return tree

def dfs(u: int, parent: int, tree: Dict[int, Dict[int, str]], path: str, paths: Dict[int, str]):
    paths[u] = path
    for (v, c) in tree[u].items():
        if v != parent:
            dfs(v, u, tree, path + c, paths)

def count_substrings(strings: List[str]) -> Dict[str, List[int]]:
    counts = defaultdict(lambda : [0] * len(strings))
    for (i, s) in enumerate(strings):
        for j in range(len(s)):
            for k in range(j + 1, len(s) + 1):
                counts[s[j:k]][i] += 1
    return counts

def solve_query(u: int, v: int, l: int, r: int, paths: Dict[int, str], counts: Dict[str, List[int]]) -> int:
    path = paths[u] if u < v else paths[u][::-1]
    return sum((counts[path][i] for i in range(l, r + 1)))

def solution(input_str: str) -> str:
    (n, m, q, edges, strings, queries) = parse_input(input_str)
    tree = build_tree(n, edges)
    paths = {}
    dfs(1, 0, tree, '', paths)
    counts = count_substrings(strings)
    return '\n'.join((str(solve_query(u, v, l, r, paths, counts)) for (u, v, l, r) in queries))
