import random

def gen_input(n: int, q: int) -> str:
    input_str = str(n) + '\n'
    vertices = [1]
    for i in range(2, n + 1):
        vertex = random.choice(vertices)
        vertices.append(i)
        input_str += f'{vertex} {i}\n'
    input_str += str(q) + '\n'
    for _ in range(q):
        vertex = random.choice(vertices)
        k = random.randint(0, n)
        input_str += f'{vertex} {k}\n'
    return input_str

def batch_gen_inputs(batch_size,) -> list:
    inputs = []
    for _ in range(batch_size):
        n = random.randint(1, 10)
        q = random.randint(1, 10)
        inputs.append(gen_input(n, q))
    return inputs
