# TEST_RESULT: False
from typing import List, Tuple

def find_simple_path(graph: List[List[int]], a: int, b: int, path: List[int], visited: List[bool]) -> List[int]:
    visited[a] = True
    path.append(a)
    if a == b:
        return path
    for neighbor in graph[a]:
        if not visited[neighbor]:
            result = find_simple_path(graph, neighbor, b, path, visited)
            if result:
                return result
    path.pop()
    visited[a] = False
    return []

def process_queries(graph: List[List[int]], queries: List[Tuple[int, int]], edges: List[Tuple[int, int]]) -> Tuple[str, List[List[int]]]:
    weights = {(u, v): 0 for (u, v) in edges}
    paths = []
    for (a, b) in queries:
        path = find_simple_path(graph, a - 1, b - 1, [], [False] * len(graph))
        paths.append(path)
        for i in range(len(path) - 1):
            (u, v) = (path[i], path[i + 1])
            weights[min(u, v), max(u, v)] += 1
    extra_queries = 0
    for weight in weights.values():
        if weight % 2 != 0:
            extra_queries += 1
    if extra_queries == 0:
        return ('YES', paths)
    else:
        return ('NO', extra_queries // 2)

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    (n, m) = map(int, lines[0].split())
    edges = [tuple(map(int, lines[i].split())) for i in range(1, m + 1)]
    q = int(lines[m + 1])
    queries = [tuple(map(int, lines[i + m + 2].split())) for i in range(q)]
    graph = [[] for _ in range(n)]
    for (u, v) in edges:
        graph[u - 1].append(v - 1)
        graph[v - 1].append(u - 1)
    (status, result) = process_queries(graph, queries, edges)
    output = [status]
    if status == 'YES':
        for path in result:
            output.append(str(len(path)))
            output.append(' '.join((str(node + 1) for node in path)))
    else:
        output.append(str(result))
    return '\n'.join(output)
