# TEST_RESULT: True

def is_palindrome(s):
    return s == s[::-1]

def erase_combinations(s, c):
    indices = [i for (i, x) in enumerate(s) if x == c]
    for i in range(2 ** len(indices)):
        erased = [False] * len(s)
        for j in range(len(indices)):
            if i >> j & 1 == 1:
                erased[indices[j]] = True
        yield ''.join((s[k] for k in range(len(s)) if not erased[k]))

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    output = []
    for i in range(t):
        n = int(lines[2 * i + 1])
        s = lines[2 * i + 2]
        min_erased = float('inf')
        for c in 'abcdefghijklmnopqrstuvwxyz':
            for s_erased in erase_combinations(s, c):
                if is_palindrome(s_erased):
                    min_erased = min(min_erased, n - len(s_erased))
        output.append(str(-1 if min_erased == float('inf') else min_erased))
    return '\n'.join(output)
