# TEST_RESULT: True

def solution(stdin: str) -> str:

    def calculate_axis_coverage(segment_lengths, placements):
        coverage_start = 0
        coverage_end = 0
        current_coordinate = 0
        for i in range(len(segment_lengths)):
            if placements[i] == '0':
                current_coordinate -= segment_lengths[i]
            else:
                current_coordinate += segment_lengths[i]
            coverage_start = min(coverage_start, current_coordinate)
            coverage_end = max(coverage_end, current_coordinate)
        return coverage_end - coverage_start
    lines = stdin.strip().split('\n')
    t = int(lines[0])
    test_cases = []
    for i in range(1, len(lines), 2):
        n = int(lines[i])
        segment_lengths = list(map(int, lines[i + 1].split()))
        test_cases.append(segment_lengths)
    result = []
    for segment_lengths in test_cases:
        n = len(segment_lengths)
        min_coverage = float('inf')
        for i in range(2 ** (n - 1)):
            placements = bin(i)[2:].zfill(n - 1) + '1'
            coverage_length = calculate_axis_coverage(segment_lengths, placements)
            min_coverage = min(min_coverage, coverage_length)
        result.append(str(min_coverage))
    return '\n'.join(result)
