# TEST_RESULT: True
from itertools import combinations
from math import sqrt

def solution(stdin: str) -> str:
    lines = stdin.strip().split('\n')
    (n, k) = map(int, lines[0].split())
    habitats = [list(map(int, line.split())) for line in lines[1:]]
    min_radius = float('inf')
    for comb in combinations(habitats, k):
        radius = max((sqrt(x ** 2 + y ** 2) for (x, y) in comb))
        min_radius = min(min_radius, radius)
    return '{:.10f}'.format(min_radius)
