/*
 * Decompiled with CFR 0.152.
 */
package engine.core;

import engine.core.MarioAgentEvent;
import engine.core.MarioEvent;
import engine.core.MarioWorld;
import engine.helper.EventType;
import engine.helper.GameStatus;
import engine.helper.SpriteType;
import java.util.ArrayList;

public class MarioResult {
    private MarioWorld world;
    private ArrayList<MarioEvent> gameEvents;
    private ArrayList<MarioAgentEvent> agentEvents;

    public MarioResult(MarioWorld marioWorld, ArrayList<MarioEvent> arrayList, ArrayList<MarioAgentEvent> arrayList2) {
        this.world = marioWorld;
        this.gameEvents = arrayList;
        this.agentEvents = arrayList2;
    }

    public GameStatus getGameStatus() {
        return this.world.gameStatus;
    }

    public float getCompletionPercentage() {
        return this.world.mario.x / (float)(this.world.level.exitTileX * 16);
    }

    public int getRemainingTime() {
        return this.world.currentTimer;
    }

    public int getMarioMode() {
        int n = 0;
        if (this.world.mario.isLarge) {
            n = 1;
        }
        if (this.world.mario.isFire) {
            n = 2;
        }
        return n;
    }

    public ArrayList<MarioEvent> getGameEvents() {
        return this.gameEvents;
    }

    public ArrayList<MarioAgentEvent> getAgentEvents() {
        return this.agentEvents;
    }

    public int getKillsTotal() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.STOMP_KILL.getValue() && marioEvent.getEventType() != EventType.FIRE_KILL.getValue() && marioEvent.getEventType() != EventType.FALL_KILL.getValue() && marioEvent.getEventType() != EventType.SHELL_KILL.getValue()) continue;
            ++n;
        }
        return n;
    }

    public int getKillsByFire() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.FIRE_KILL.getValue()) continue;
            ++n;
        }
        return n;
    }

    public int getKillsByStomp() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.STOMP_KILL.getValue()) continue;
            ++n;
        }
        return n;
    }

    public int getKillsByShell() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.SHELL_KILL.getValue()) continue;
            ++n;
        }
        return n;
    }

    public int getMarioNumKills(int n) {
        int n2 = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.SHELL_KILL.getValue() && marioEvent.getEventType() != EventType.FIRE_KILL.getValue() && marioEvent.getEventType() != EventType.STOMP_KILL.getValue() || marioEvent.getEventParam() != n) continue;
            ++n2;
        }
        return n2;
    }

    public int getMarioNumHurts() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.HURT.getValue()) continue;
            ++n;
        }
        return n;
    }

    public int getNumBumpQuestionBlock() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.BUMP.getValue() || marioEvent.getEventParam() != 24) continue;
            ++n;
        }
        return n;
    }

    public int getNumBumpBrick() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.BUMP.getValue() || marioEvent.getEventParam() != 22) continue;
            ++n;
        }
        return n;
    }

    public int getKillsByFall() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.FALL_KILL.getValue()) continue;
            ++n;
        }
        return n;
    }

    public int getNumJumps() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.JUMP.getValue()) continue;
            ++n;
        }
        return n;
    }

    public float getMaxXJump() {
        float f = 0.0f;
        float f2 = -100.0f;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() == EventType.JUMP.getValue()) {
                f2 = marioEvent.getMarioX();
            }
            if (marioEvent.getEventType() != EventType.LAND.getValue() || !(Math.abs(marioEvent.getMarioX() - f2) > f)) continue;
            f = Math.abs(marioEvent.getMarioX() - f2);
        }
        return f;
    }

    public int getMaxJumpAirTime() {
        int n = 0;
        int n2 = -100;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() == EventType.JUMP.getValue()) {
                n2 = marioEvent.getTime();
            }
            if (marioEvent.getEventType() != EventType.LAND.getValue() || marioEvent.getTime() - n2 <= n) continue;
            n = marioEvent.getTime() - n2;
        }
        return n;
    }

    public int getCurrentLives() {
        return this.world.lives;
    }

    public int getCurrentCoins() {
        return this.world.coins;
    }

    public int getNumCollectedMushrooms() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.COLLECT.getValue() || marioEvent.getEventParam() != SpriteType.MUSHROOM.getValue()) continue;
            ++n;
        }
        return n;
    }

    public int getNumCollectedFireflower() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.COLLECT.getValue() || marioEvent.getEventParam() != SpriteType.FIRE_FLOWER.getValue()) continue;
            ++n;
        }
        return n;
    }

    public int getNumCollectedTileCoins() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.COLLECT.getValue() || marioEvent.getEventParam() != 31) continue;
            ++n;
        }
        return n;
    }

    public int getNumDestroyedBricks() {
        int n = 0;
        for (MarioEvent marioEvent : this.gameEvents) {
            if (marioEvent.getEventType() != EventType.BUMP.getValue() || marioEvent.getEventParam() != 22 || marioEvent.getMarioState() <= 0) continue;
            ++n;
        }
        return n;
    }
}

