/*
 * Decompiled with CFR 0.152.
 */
package agents.robinBaumgarten;

import agents.robinBaumgarten.Helper;
import agents.robinBaumgarten.SearchNode;
import engine.core.MarioForwardModel;
import engine.core.MarioTimer;
import engine.helper.GameStatus;
import java.util.ArrayList;

public class AStarTree {
    public SearchNode bestPosition;
    public SearchNode furthestPosition;
    float currentSearchStartingMarioXPos;
    ArrayList<SearchNode> posPool;
    ArrayList<int[]> visitedStates = new ArrayList();
    private boolean requireReplanning = false;
    private ArrayList<boolean[]> currentActionPlan;
    int ticksBeforeReplanning = 0;

    private MarioForwardModel search(MarioTimer marioTimer) {
        SearchNode searchNode = this.bestPosition;
        boolean bl = false;
        int n = 176;
        while (this.posPool.size() != 0 && (this.bestPosition.sceneSnapshot.getMarioFloatPos()[0] - this.currentSearchStartingMarioXPos < (float)n || !bl) && marioTimer.getRemainingTime() > 0L) {
            searchNode = this.pickBestPos(this.posPool);
            if (searchNode == null) {
                return null;
            }
            bl = false;
            float f = searchNode.simulatePos();
            if (f < 0.0f) continue;
            if (!searchNode.isInVisitedList && this.isInVisited((int)searchNode.sceneSnapshot.getMarioFloatPos()[0], (int)searchNode.sceneSnapshot.getMarioFloatPos()[1], searchNode.timeElapsed)) {
                searchNode.isInVisitedList = true;
                searchNode.remainingTime = f += 1500.0f;
                searchNode.remainingTimeEstimated = f;
                this.posPool.add(searchNode);
            } else if ((double)(f - searchNode.remainingTimeEstimated) > 0.1) {
                searchNode.remainingTimeEstimated = f;
                this.posPool.add(searchNode);
            } else {
                bl = true;
                this.visited((int)searchNode.sceneSnapshot.getMarioFloatPos()[0], (int)searchNode.sceneSnapshot.getMarioFloatPos()[1], searchNode.timeElapsed);
                this.posPool.addAll(searchNode.generateChildren());
            }
            if (!bl) continue;
            if (this.bestPosition.getRemainingTime() > searchNode.getRemainingTime()) {
                this.bestPosition = searchNode;
            }
            if (!(searchNode.sceneSnapshot.getMarioFloatPos()[0] > this.furthestPosition.sceneSnapshot.getMarioFloatPos()[0])) continue;
            this.furthestPosition = searchNode;
        }
        if (searchNode.sceneSnapshot.getMarioFloatPos()[0] - this.currentSearchStartingMarioXPos < (float)n && this.furthestPosition.sceneSnapshot.getMarioFloatPos()[0] > this.bestPosition.sceneSnapshot.getMarioFloatPos()[0] + 20.0f) {
            this.bestPosition = this.furthestPosition;
        }
        return searchNode.sceneSnapshot;
    }

    private void startSearch(MarioForwardModel marioForwardModel, int n) {
        SearchNode searchNode = new SearchNode(null, n, null);
        searchNode.initializeRoot(marioForwardModel);
        this.posPool = new ArrayList();
        this.visitedStates.clear();
        this.posPool.addAll(searchNode.generateChildren());
        this.currentSearchStartingMarioXPos = marioForwardModel.getMarioFloatPos()[0];
        this.bestPosition = searchNode;
        this.furthestPosition = searchNode;
    }

    private ArrayList<boolean[]> extractPlan() {
        ArrayList<boolean[]> arrayList = new ArrayList<boolean[]>();
        if (this.bestPosition == null) {
            for (int i = 0; i < 10; ++i) {
                arrayList.add(Helper.createAction(false, true, false, false, true));
            }
            return arrayList;
        }
        SearchNode searchNode = this.bestPosition;
        while (searchNode.parentPos != null) {
            for (int i = 0; i < searchNode.repetitions; ++i) {
                arrayList.add(0, searchNode.action);
            }
            if (searchNode.hasBeenHurt) {
                this.requireReplanning = true;
            }
            searchNode = searchNode.parentPos;
        }
        return arrayList;
    }

    private SearchNode pickBestPos(ArrayList<SearchNode> arrayList) {
        SearchNode searchNode = null;
        float f = 1.0E7f;
        for (SearchNode searchNode2 : arrayList) {
            float f2 = searchNode2.getRemainingTime() + (float)searchNode2.timeElapsed * 0.9f;
            if (!(f2 < f)) continue;
            searchNode = searchNode2;
            f = f2;
        }
        arrayList.remove(searchNode);
        return searchNode;
    }

    public boolean[] optimise(MarioForwardModel marioForwardModel, MarioTimer marioTimer) {
        int n = 2;
        int n2 = 2;
        MarioForwardModel marioForwardModel2 = marioForwardModel.clone();
        --this.ticksBeforeReplanning;
        this.requireReplanning = false;
        if (this.ticksBeforeReplanning <= 0 || this.currentActionPlan.size() == 0 || this.requireReplanning) {
            this.currentActionPlan = this.extractPlan();
            if (this.currentActionPlan.size() < n) {
                n = this.currentActionPlan.size();
            }
            for (int i = 0; i < n; ++i) {
                marioForwardModel.advance(this.currentActionPlan.get(i));
            }
            this.startSearch(marioForwardModel, n2);
            this.ticksBeforeReplanning = n;
        }
        if (marioForwardModel.getGameStatus() == GameStatus.LOSE) {
            this.startSearch(marioForwardModel2, n2);
        }
        this.search(marioTimer);
        boolean[] blArray = new boolean[5];
        if (this.currentActionPlan.size() > 0) {
            blArray = this.currentActionPlan.remove(0);
        }
        return blArray;
    }

    private void visited(int n, int n2, int n3) {
        this.visitedStates.add(new int[]{n, n2, n3});
    }

    private boolean isInVisited(int n, int n2, int n3) {
        int n4 = 5;
        int n5 = 2;
        int n6 = 2;
        for (int[] nArray : this.visitedStates) {
            if (Math.abs(nArray[0] - n) >= n5 || Math.abs(nArray[1] - n2) >= n6 || Math.abs(nArray[2] - n3) >= n4 || n3 < nArray[2]) continue;
            return true;
        }
        return false;
    }
}

