/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.EventType;
import engine.helper.SpriteType;
import java.awt.Graphics;

public class LifeMushroom
extends MarioSprite {
    private boolean onGround = false;
    private int life;
    private MarioImage graphics;
    private static final float GROUND_INERTIA = 0.89f;
    private static final float AIR_INERTIA = 0.89f;

    public LifeMushroom(boolean bl, float f, float f2) {
        super(f, f2, SpriteType.LIFE_MUSHROOM);
        this.width = 4;
        this.height = 12;
        this.facing = 1;
        this.life = 0;
        if (bl) {
            this.graphics = new MarioImage(Assets.items, 3);
            this.graphics.width = 16;
            this.graphics.height = 16;
            this.graphics.originX = 8;
            this.graphics.originY = 15;
        }
    }

    @Override
    public MarioSprite clone() {
        LifeMushroom lifeMushroom = new LifeMushroom(false, this.x, this.y);
        lifeMushroom.xa = this.xa;
        lifeMushroom.ya = this.ya;
        lifeMushroom.initialCode = this.initialCode;
        lifeMushroom.width = this.width;
        lifeMushroom.height = this.height;
        lifeMushroom.facing = this.facing;
        lifeMushroom.life = this.life;
        lifeMushroom.onGround = this.onGround;
        return lifeMushroom;
    }

    @Override
    public void collideCheck() {
        if (!this.alive) {
            return;
        }
        float f = this.world.mario.x - this.x;
        float f2 = this.world.mario.y - this.y;
        if (f > -16.0f && f < 16.0f && f2 > (float)(-this.height) && f2 < (float)this.world.mario.height) {
            this.world.addEvent(EventType.COLLECT, this.type.getValue());
            this.world.mario.collect1Up();
            this.world.removeSprite(this);
        }
    }

    private boolean isBlocking(float f, float f2, float f3, float f4) {
        int n = (int)(f / 16.0f);
        int n2 = (int)(f2 / 16.0f);
        if (n == (int)(this.x / 16.0f) && n2 == (int)(this.y / 16.0f)) {
            return false;
        }
        boolean bl = this.world.level.isBlocking(n, n2, f3, f4);
        return bl;
    }

    @Override
    public void bumpCheck(int n, int n2) {
        if (!this.alive) {
            return;
        }
        if (this.x + (float)this.width > (float)(n * 16) && this.x - (float)this.width < (float)(n * 16 + 16) && n2 == (int)((this.y - 1.0f) / 16.0f)) {
            this.facing = -this.world.mario.facing;
            this.ya = -10.0f;
        }
    }

    private boolean move(float f, float f2) {
        while (f > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            f -= 8.0f;
        }
        while (f < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            f += 8.0f;
        }
        while (f2 > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            f2 -= 8.0f;
        }
        while (f2 < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            f2 += 8.0f;
        }
        boolean bl = false;
        if (f2 > 0.0f) {
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)this.width, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            }
        }
        if (f2 < 0.0f) {
            if (this.isBlocking(this.x + f, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
        }
        if (f > 0.0f) {
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)(this.height / 2), f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2, f, f2)) {
                bl = true;
            }
        }
        if (f < 0.0f) {
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)(this.height / 2), f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2, f, f2)) {
                bl = true;
            }
        }
        if (bl) {
            if (f < 0.0f) {
                this.x = (int)((this.x - (float)this.width) / 16.0f) * 16 + this.width;
                this.xa = 0.0f;
            }
            if (f > 0.0f) {
                this.x = (int)((this.x + (float)this.width) / 16.0f + 1.0f) * 16 - this.width - 1;
                this.xa = 0.0f;
            }
            if (f2 < 0.0f) {
                this.y = (int)((this.y - (float)this.height) / 16.0f) * 16 + this.height;
                this.ya = 0.0f;
            }
            if (f2 > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += f;
        this.y += f2;
        return true;
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        if (this.life < 9) {
            this.y -= 1.0f;
            ++this.life;
            return;
        }
        float f = 1.75f;
        if (this.xa > 2.0f) {
            this.facing = 1;
        }
        if (this.xa < -2.0f) {
            this.facing = -1;
        }
        this.xa = (float)this.facing * f;
        if (!this.move(this.xa, 0.0f)) {
            this.facing = -this.facing;
        }
        this.onGround = false;
        this.move(0.0f, this.ya);
        this.ya *= 0.85f;
        this.xa = this.onGround ? (this.xa *= 0.89f) : (this.xa *= 0.89f);
        if (!this.onGround) {
            this.ya += 2.0f;
        }
    }

    @Override
    public void render(Graphics graphics) {
        super.render(graphics);
        this.graphics.render(graphics, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }
}

