/*
 * Decompiled with CFR 0.152.
 */
package engine.sprites;

import engine.core.MarioSprite;
import engine.graphics.MarioImage;
import engine.helper.Assets;
import engine.helper.SpriteType;
import java.awt.Graphics;

public class Fireball
extends MarioSprite {
    private static final float GROUND_INERTIA = 0.89f;
    private static final float AIR_INERTIA = 0.89f;
    private boolean onGround = false;
    private MarioImage graphics;
    private int anim = 0;

    public Fireball(boolean bl, float f, float f2, int n) {
        super(f, f2, SpriteType.FIREBALL);
        this.facing = n;
        this.ya = 4.0f;
        this.width = 4;
        this.height = 8;
        if (bl) {
            this.graphics = new MarioImage(Assets.particles, 24);
            this.graphics.originX = 8;
            this.graphics.originY = 8;
            this.graphics.width = 16;
            this.graphics.height = 16;
        }
    }

    @Override
    public MarioSprite clone() {
        Fireball fireball = new Fireball(false, this.x, this.y, this.facing);
        fireball.xa = this.xa;
        fireball.ya = this.ya;
        fireball.initialCode = this.initialCode;
        fireball.width = this.width;
        fireball.height = this.height;
        fireball.onGround = this.onGround;
        return fireball;
    }

    private boolean move(float f, float f2) {
        while (f > 8.0f) {
            if (!this.move(8.0f, 0.0f)) {
                return false;
            }
            f -= 8.0f;
        }
        while (f < -8.0f) {
            if (!this.move(-8.0f, 0.0f)) {
                return false;
            }
            f += 8.0f;
        }
        while (f2 > 8.0f) {
            if (!this.move(0.0f, 8.0f)) {
                return false;
            }
            f2 -= 8.0f;
        }
        while (f2 < -8.0f) {
            if (!this.move(0.0f, -8.0f)) {
                return false;
            }
            f2 += 8.0f;
        }
        boolean bl = false;
        if (f2 > 0.0f) {
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)this.width, this.y + f2, f, 0.0f)) {
                bl = true;
            } else if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            } else if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 + 1.0f, f, f2)) {
                bl = true;
            }
        }
        if (f2 < 0.0f) {
            if (this.isBlocking(this.x + f, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            } else if (bl || this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
        }
        if (f > 0.0f) {
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2 - (float)(this.height / 2), f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f + (float)this.width, this.y + f2, f, f2)) {
                bl = true;
            }
        }
        if (f < 0.0f) {
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)this.height, f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2 - (float)(this.height / 2), f, f2)) {
                bl = true;
            }
            if (this.isBlocking(this.x + f - (float)this.width, this.y + f2, f, f2)) {
                bl = true;
            }
        }
        if (bl) {
            if (f < 0.0f) {
                this.x = (int)((this.x - (float)this.width) / 16.0f) * 16 + this.width;
                this.xa = 0.0f;
            }
            if (f > 0.0f) {
                this.x = (int)((this.x + (float)this.width) / 16.0f + 1.0f) * 16 - this.width - 1;
                this.xa = 0.0f;
            }
            if (f2 < 0.0f) {
                this.y = (int)((this.y - (float)this.height) / 16.0f) * 16 + this.height;
                this.ya = 0.0f;
            }
            if (f2 > 0.0f) {
                this.y = (int)(this.y / 16.0f + 1.0f) * 16 - 1;
                this.onGround = true;
            }
            return false;
        }
        this.x += f;
        this.y += f2;
        return true;
    }

    private boolean isBlocking(float f, float f2, float f3, float f4) {
        int n = (int)(f / 16.0f);
        int n2 = (int)(f2 / 16.0f);
        if (n == (int)(this.x / 16.0f) && n2 == (int)(this.y / 16.0f)) {
            return false;
        }
        boolean bl = this.world.level.isBlocking(n, n2, f3, f4);
        return bl;
    }

    @Override
    public void update() {
        if (!this.alive) {
            return;
        }
        if (this.facing != 0) {
            ++this.anim;
        }
        float f = 8.0f;
        if (this.xa > 2.0f) {
            this.facing = 1;
        }
        if (this.xa < -2.0f) {
            this.facing = -1;
        }
        this.xa = (float)this.facing * f;
        this.world.checkFireballCollide(this);
        if (!this.move(this.xa, 0.0f)) {
            this.world.removeSprite(this);
            return;
        }
        this.onGround = false;
        this.move(0.0f, this.ya);
        if (this.onGround) {
            this.ya = -10.0f;
        }
        this.ya *= 0.95f;
        this.xa = this.onGround ? (this.xa *= 0.89f) : (this.xa *= 0.89f);
        if (!this.onGround) {
            this.ya = (float)((double)this.ya + 1.5);
        }
        if (this.graphics != null) {
            this.graphics.flipX = this.facing == -1;
            this.graphics.index = 24 + this.anim % 4;
        }
    }

    @Override
    public void render(Graphics graphics) {
        super.render(graphics);
        this.graphics.render(graphics, (int)(this.x - this.world.cameraX), (int)(this.y - this.world.cameraY));
    }
}

