import os
import cv2
import imageio
from matplotlib import animation
import matplotlib.pyplot as plt
import numpy as np

def save_frames_as_gif(frames, path='./', filename='gym_animation.gif'):

    #Mess with this to change frame size
    plt.figure(figsize=(frames[0].shape[1] / 72.0, frames[0].shape[0] / 72.0), dpi=72)

    patch = plt.imshow(frames[0])
    plt.axis('off')

    def animate(i):
        patch.set_data(frames[i])

    anim = animation.FuncAnimation(plt.gcf(), animate, frames = len(frames), interval=50)
    anim.save(path + filename, writer='imagemagick', fps=60)

def save_video(frames, filename):
    # video_name = os.path.join(video_dir, "{}_{}.mp4".format(env_name, version))
    video_name = filename
    with imageio.get_writer(video_name, fps=30) as writer:
        im_shape = frames[-1].shape
        for im in frames:
            # convert BGR to RGB
            im = im[:, :, ::-1]
            if (im.shape[0] != im_shape[0]) or (im.shape[1] != im_shape[1]):
                im = cv2.resize(im, (im_shape[1], im_shape[0]))
            writer.append_data(im.astype(np.uint8))
        writer.close()
    print("Video saved to {}".format(video_name))