
import MAT

function uci_regression_dataset(dataset::Symbol)
    dataset = MAT.matread(
        datadir("datasets", "uci_regression", "$(string(dataset)).mat"))["data"]
    X = dataset[:, 1:end-1]
    y = dataset[:, end]

    μ_X  = mean(X, dims = 1)
    σ_X  = std(X, dims = 1) .+ 1f-6
    X  .-= μ_X
    X  ./= σ_X

    μ_y  = mean(y)
    σ_y  = std(y)
    y  .-= μ_y
    y   /= σ_y

    X, y, σ_y
end

function train_test_split(idx, r; rng=Random.GLOBAL_RNG)
    n_data    = length(idx)
    n_test    = round(Int, n_data*r)
    test_idx  = sample(rng, idx, n_test; replace=false)
    train_idx = setdiff(idx, test_idx)
    train_idx, test_idx
end
