#! /usr/bin/env bash

w=('gaussian_noise' 'shot_noise' 'impulse_noise' 'speckle_noise'
   'defocus_blur' 'glass_blur' 'motion_blur' 'zoom_blur' 'gaussian_blur'
   'snow' 'frost' 'fog' 'brightness' 'contrast' 'elastic_transform' 'pixelate'
   'jpeg_compression' 'spatter' 'saturate')

for i in ${w[@]};
do
python train_BETA.py configs/cifar100/BETA.py --cfg-options corruption=$i
python finetune.py configs/cifar100/finetune.py --cfg-options corruption=$i test_interval=1 load="checkpoints/cifar100/BETA/${i}/last.pth"
done;