from gym.envs.registration import register

# Mujoco
# ----------------------------------------

# - randomised reward functions

register(
    'AntDir-v0',
    entry_point='environments.wrappers:mujoco_wrapper',
    kwargs={'entry_point': 'environments.mujoco.ant_dir:AntDirEnv',
            'max_episode_steps': 200},
    max_episode_steps=200
)

register(
    'AntDir2D-v0',
    entry_point='environments.wrappers:mujoco_wrapper',
    kwargs={'entry_point': 'environments.mujoco.ant_dir:AntDir2DEnv',
            'max_episode_steps': 200},
    max_episode_steps=200,
)

register(
    'AntGoal-v0',
    entry_point='environments.wrappers:mujoco_wrapper',
    kwargs={'entry_point': 'environments.mujoco.ant_goal:AntGoalEnv',
            'max_episode_steps': 200},
    max_episode_steps=200
)

register(
    'HalfCheetahDir-v0',
    entry_point='environments.wrappers:mujoco_wrapper',
    kwargs={'entry_point': 'environments.mujoco.half_cheetah_dir:HalfCheetahDirEnv',
            'max_episode_steps': 200},
    max_episode_steps=200
)

register(
    'HalfCheetahVel-v0',
    entry_point='environments.wrappers:mujoco_wrapper',
    kwargs={'entry_point': 'environments.mujoco.half_cheetah_vel:HalfCheetahVelEnv',
            'max_episode_steps': 200},
    max_episode_steps=200
)

register(
    'HumanoidDir-v0',
    entry_point='environments.wrappers:mujoco_wrapper',
    kwargs={'entry_point': 'environments.mujoco.humanoid_dir:HumanoidDirEnv',
            'max_episode_steps': 200},
    max_episode_steps=200
)

# - randomised dynamics

register(
    id='Walker2DRandParams-v0',
    entry_point='environments.mujoco.rand_param_envs.walker2d_rand_params:Walker2DRandParamsEnv',
    max_episode_steps=200
)

register(
    id='HopperRandParams-v0',
    entry_point='environments.mujoco.rand_param_envs.hopper_rand_params:HopperRandParamsEnv',
    max_episode_steps=200
)


# # 2D Navigation
# # ----------------------------------------
#
register(
    'PointEnv-v0',
    entry_point='environments.navigation.point_robot:PointEnv',
    kwargs={'goal_radius': 0.2,
            'max_episode_steps': 100,
            'goal_sampler': 'semi-circle'
            },
    max_episode_steps=100,
)

register(
    'SparsePointEnv-v0',
    entry_point='environments.navigation.point_robot:SparsePointEnv',
    kwargs={'goal_radius': 0.2,
            'max_episode_steps': 100,
            'goal_sampler': 'semi-circle'
            },
    max_episode_steps=100,
)

# # ML 10
register(
    'ML10Env-v2',
    entry_point='environments.metaworld.ml10:ML10',
    kwargs={'max_episode_steps': 500,
            'SEED': 10,
            },
    max_episode_steps=500,
)

register(
    'ML10TimeEnv-v2',
    entry_point='environments.metaworld.ml10_time:ML10_TIME',
    kwargs={'max_episode_steps': 500,
            'SEED': 10,
            },
    max_episode_steps=500,
)

register(
    'ML10POSTEnv-v2',
    entry_point='environments.metaworld.ml10_post:ML10_POST',
    kwargs={'max_episode_steps': 500,
            'SEED': 10,
            },
    max_episode_steps=500,
)

register(
    'ML10RENDEREnv-v2',
    entry_point='environments.metaworld.ml10_render:ML10_RENDER',
    kwargs={'max_episode_steps': 500,
            'SEED': 10,
            },
    max_episode_steps=500,
)

# # ML 10 test
register(
    'ML10TESTEnv-v2',
    entry_point='environments.metaworld.ml10test:ML10TEST',
    kwargs={'max_episode_steps': 500,
            'SEED': 10,
            },
    max_episode_steps=500,
)

# # ML 45
register(
    'ML45Env-v2',
    entry_point='environments.metaworld.ml45:ML45',
    kwargs={'max_episode_steps': 500,
            'SEED': 10,
            },
    max_episode_steps=500,
)

#
# # GridWorld
# # ----------------------------------------

register(
    'GridNavi-v0',
    entry_point='environments.navigation.gridworld:GridNavi',
    kwargs={'num_cells': 5, 'num_steps': 15},
)
