from scipy.optimize import linprog
import numpy as np


class OfflineSCAlgo:
    @staticmethod
    def solve(sc_input):
        lhs_ineq = -sc_input.connections.copy()
        rhs_ineq = -np.ones(sc_input.num_elems)
        goal = sc_input.set_prices
        result = linprog(goal, A_ub=lhs_ineq, b_ub=rhs_ineq, method='highs')
        return result.fun, result.x
