# We implement RefSolver on top of a modified pomdp_py package
# The License included here is the license for pomdp_py 

Dependencies
- numpy
- scipy
- tqdm
- matplotlib

Algorithm implementations
- RefSolver `pomdp_py/algorithms/ref_solver_clean.py`

Problem implementations

- Gridworld Navigation 1: Long Horizon  `problems/gridworld/gridworld_dzs_60x60.py`
- Gridworld Navigation 2: Slightly Perturbed Environment  `problems/gridworld/gridworld_rand_obstacles_scalable.py`



# Running the Program

```bash

## Linux

PYTHONPATH="$PWD" python [problem implementations] 

For example:

To get the results we presented for Navigation 1 (both RefSolver and POMCP), please run:
PYTHONPATH="$PWD" python problems/gridworld/gridworld_dzs_60x60.py

To get the results we presented for Navigation 2 (both RefSolver and POMCP), please run:
PYTHONPATH="$PWD" python problems/gridworld/gridworld_rand_obstacles_scalable.py


## Windows
PYTHONPATH=<Repositroy root directory> python [problem implementations] 
```

# Notes:
Tested on Python 3.10
The code will be substantially cleaned and released as an open source software together with the paper, if the paper is accepted.

