from .functions.binarize import reswish_binarize
from .qconv2d import QConv2d


class BinConv2d(QConv2d):
    """
        Binary Conv2d module.
    """
    def __init__(self, *args, beta, **kwargs):
        """
        :param list args: args for :class:`antgine.modules.quantization.qconv2d.QConv2d`.
        :param float beta: beta assigned to Reswish.
        :param dict[str, any] kwargs: kwargs for :class:`antgine.modules.quantization.qconv2d.QConv2d`.
        """
        super().__init__(*args, qfunc=lambda x: reswish_binarize(x, beta), **kwargs)
