#pragma once
#include <NTL/ZZ.h>
#include <NTL/ZZ_p.h>
#include <NTL/ZZ_pX.h>
#include <NTL/vector.h>
#include <NTL/vec_ZZ_p.h>
#include <iostream>
#include <emp-tool/emp-tool.h>
#include <vector>

using namespace std;
using namespace NTL;
using namespace emp;

// stands for long long zz
// initialize a ZZ from two 32 bit integers
// a is treated as the higher order 32 bits, b as the lower order 32 bits
ZZ ll_zz(uint32_t a, uint32_t b) {
    ZZ ret(a);
    ret = ret << 32;
    ZZ temp(b);
    ret = ret + temp;
    return ret;
}

// TODO: make sure this makes sense
ZZ_p ll_zzp(uint32_t a, uint32_t b) {
    ZZ_p ret(a);
    uint32_t temp = 0;
    temp = temp -1;
    ZZ_p shifter(temp);
    shifter += 1;
    ret = ret * shifter; // shifts a 32 places (I think?)
    // the problem is the top bits of a will roll over to the bottom,
    // and then it will not input b correctly in this case
    // TODO fix this ^
    ZZ_p bot(b);
    ret = ret + bot;
    return ret;
}


/*
// same as ll_zz but zeros out the top 4 bits to produce a 61 bit number
ZZ sixtyone_zz(uint32_t a, uint32_t b) {
    uint32_t temp = (1<<29)-1;
}
*/

// initialize the prime 2^61-1 as an NTL::ZZ
ZZ big_prime() {
    uint32_t temp1 = (1 << 29)-1;
    uint32_t temp2 = 0;
    temp2 = temp2 - 1;
    ZZ ret = ll_zz(temp1, temp2);
    return ret;
}

void init_ZZp() {
    ZZ_p::init(big_prime());
}



// takes a random 64 bit integer mod 2^61-1
// TODO: currenty gives the same randomness when called multiple times
ZZ_p rand_zzp(PRG & prg) {
    uint32_t rand1 = 0;
    uint32_t rand2 = 0;
    prg.random_data(&rand1, sizeof(rand1));
    prg.random_data(&rand2, sizeof(rand2));
    ZZ_p ret = ll_zzp(rand1, rand2);
    return ret;
}




// x is the secret
// t is the threshold
// n is the total number of shares
// requires n >= t
// right now this just returns the y values, xs are implicitly [1..n]
// note that the x values START at 1, not 0
Vec<ZZ_p> shamir_share(uint32_t s, int t, int n, PRG & prg) {
    ZZ_p secret(s);
    Vec<ZZ_p> ys;
    Vec<ZZ_p> xs;
    ys.SetLength(t);
    xs.SetLength(t);
    ys[0] = secret;
    ZZ_p field_i(0);
    xs[0] = field_i;
    for (int i=1; i<t; i++) {
        ZZ_p temp = rand_zzp(prg);
        ys[i] = temp;
        field_i = ZZ_p(i);
        xs[i] = field_i;
    }
    ZZ_pX poly = interpolate(xs, ys);

    
    // TODO: this can be optimized by not using eval() to
    // compute the first t points (theyre the same as ys)
    Vec<ZZ_p> shares;
    shares.SetLength(n);
    for (int i=0; i<n; i++) {
        field_i = ZZ_p(i+1); // i+1 so that it doesn't give the intercept
        shares[i] = eval(poly, field_i);
    }
    return shares;
}



// constructs a shared value used to verify that a secret share 
// is binary-valued.
// given share b, returns a share of b * (b-1)
ZZ_p check_binary_help(ZZ_p b) {
    ZZ_p one(1);
    return b * (b - one);
}


ZZ_p reconstruct(Vec<ZZ_p> xs, Vec<ZZ_p> shares) {
    ZZ_pX poly = interpolate(xs, shares);
    ZZ_p field_zero(0);
    ZZ_p secret = eval(poly, field_zero);
    return secret;
}


void send_ZZp(ZZ_p share, NetIO* io) {
    unsigned char tmp[8];
    ZZ x = rep(share);
    BytesFromZZ(tmp, x, 8);
    io->send_data(&tmp, 8);
}


ZZ_p recv_ZZp(NetIO* io) {
    unsigned char tmp[8];
    io->recv_data(&tmp, 8);
    ZZ x = ZZFromBytes(tmp, 8);
    ZZ_p ret = conv<ZZ_p>(x);
    return ret;
}

// return the decimal value of a sequence of binary-valued ZZ_p's
// start is the 1's place, each subsequent bit is the next power of 2
ZZ_p unsigned_debinarize(int start_ind, int nbits, Vec<ZZ_p> & ls) {
    ZZ_p sum = ZZ_p(0);
    ZZ_p place_val = ZZ_p(1);
    ZZ_p two = ZZ_p(2);
    ZZ_p temp = ZZ_p(0);
    for(int i=start_ind; i<start_ind+nbits; i++) {
        mul(temp, ls[i], place_val);
        add(sum, sum, temp); // sum += ls[i] * place_val; 
        mul(place_val, place_val, two); // place_val *= two;
    }
    return sum;
}

// interpret binary sequence as a 2's complement signed integer
//ZZ_p signed_debinarize(int start_ind, int nbits, Vec<ZZ_p> & ls) {
//    
//}