# Code for CoDrug

This repository contains the code for CoDrug - Conformal Drug Property Prediction with
Density Estimation under Covariate Shift.

## Required Installations

Before running the code in this repository, please ensure you have the following dependencies installed:

- [PyTorch](https://pytorch.org/get-started/locally/) - Follow the installation instructions on the PyTorch website to install the appropriate version for your system.
- [DGL (Deep Graph Library)](https://www.dgl.ai/pages/start.html) - Refer to the DGL documentation for installation instructions specific to your platform.
- dgllife
- rdkit
- pytorch_lightning
- tdc

You can install other dependencies using `pip` with the following command:

```
pip install dgllife rdkit pytorch_lightning PyTDC
```

## Usage

To use the code in this repository, follow these steps:

1. Change directory to the cloned repository:

   ```shell
   cd code
   ```

2. Run the `main.py` script to train the models:

   ```shell
   python main.py
   ```

   This script contains the necessary code for training the deep learning models for drug property prediction. You can modify the script as per your requirements.

3. The code for conformal prediction is available in `cp.py`.


## Trained Models and Datasplits

Trained models and the datasplits used for all the experiments will be made available if the paper associated gets accepted. Due to limited space, we are unable to include them at the moment. 
