# Maps are from https://nethackwiki.com/wiki/Sokoban#Level_descriptions
# All holes beside the last one are marked as empty, and the last hole is bottomless.
# That should deal with potential boulders destroyed by monsters

maps = {'''\
    -------- ------
    |<|>...---....|
    |^|-.00....0..|
    |.||..00|.0.0.|
    |.||....|.....|
    |.|------0----|
    |.|    |......|
    |.------......|
    |......0000...|
    |??-----......|
    ----   --------''': [((2, 5), (1, 0)), ((2, 6), (0, 1)), ((2, 7), (0, 1)), ((2, 8), (0, 1)), ((2, 9), (0, 1)),
                         ((5, 9), (1, 0)), ((6, 9), (1, 0)), ((8, 8), (-1, 0)), ((8, 7), (0, -1)), ((8, 6), (0, -1)),
                         ((8, 5), (0, -1)), ((8, 4), (0, -1)), ((8, 3), (0, -1)), ((8, 2), (0, -1)), ((8, 1), (-1, 0)),
                         ((7, 1), (-1, 0)), ((6, 1), (-1, 0)), ((5, 1), (-1, 0)), ((4, 1), (-1, 0)), ((3, 1), (-1, 0)),
                         ((8, 10), (-1, 0)), ((8, 9), (0, -1)), ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (0, -1)),
                         ((8, 5), (0, -1)), ((8, 4), (0, -1)), ((8, 3), (0, -1)), ((8, 2), (0, -1)), ((8, 1), (-1, 0)),
                         ((7, 1), (-1, 0)), ((6, 1), (-1, 0)), ((5, 1), (-1, 0)), ((4, 1), (-1, 0)), ((3, 1), (-1, 0)),
                         ((7, 10), (1, 0)), ((8, 10), (0, -1)), ((8, 9), (0, -1)), ((8, 8), (0, -1)), ((8, 7), (0, -1)),
                         ((8, 6), (0, -1)), ((8, 5), (0, -1)), ((8, 4), (0, -1)), ((8, 3), (0, -1)), ((8, 2), (0, -1)),
                         ((8, 1), (-1, 0)), ((7, 1), (-1, 0)), ((6, 1), (-1, 0)), ((5, 1), (-1, 0)), ((4, 1), (-1, 0)),
                         ((3, 1), (-1, 0)), ((7, 9), (1, 0)), ((8, 9), (0, -1)), ((8, 8), (0, -1)), ((8, 7), (0, -1)),
                         ((8, 6), (0, -1)), ((8, 5), (0, -1)), ((8, 4), (0, -1)), ((8, 3), (0, -1)), ((8, 2), (0, -1)),
                         ((8, 1), (-1, 0)), ((7, 1), (-1, 0)), ((6, 1), (-1, 0)), ((5, 1), (-1, 0)), ((4, 1), (-1, 0)),
                         ((3, 1), (-1, 0)), ((7, 8), (1, 0)), ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (0, -1)),
                         ((8, 5), (0, -1)), ((8, 4), (0, -1)), ((8, 3), (0, -1)), ((8, 2), (0, -1)), ((8, 1), (-1, 0)),
                         ((7, 1), (-1, 0)), ((6, 1), (-1, 0)), ((5, 1), (-1, 0)), ((4, 1), (-1, 0)), ((3, 1), (-1, 0)),
                         ((3, 10), (0, -1)), ((2, 11), (1, 0)), ((2, 10), (0, -1)), ((2, 9), (0, -1)), ((3, 9), (1, 0)),
                         ((4, 9), (1, 0)), ((5, 9), (1, 0)), ((6, 9), (1, 0)), ((7, 9), (1, 0)), ((8, 9), (0, -1)),
                         ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (0, -1)), ((8, 4), (0, -1)),
                         ((8, 3), (0, -1)), ((8, 2), (0, -1)), ((8, 1), (-1, 0)), ((7, 1), (-1, 0)), ((6, 1), (-1, 0)),
                         ((5, 1), (-1, 0)), ((4, 1), (-1, 0)), ((3, 1), (-1, 0)), ((3, 11), (1, 0)), ((4, 11), (0, -1)),
                         ((4, 10), (0, -1)), ((4, 9), (1, 0)), ((5, 9), (1, 0)), ((6, 9), (1, 0)), ((7, 9), (1, 0)),
                         ((8, 9), (0, -1)), ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (0, -1)),
                         ((8, 4), (0, -1)), ((8, 3), (0, -1)), ((8, 2), (0, -1)), ((8, 1), (-1, 0)), ((7, 1), (-1, 0)),
                         ((6, 1), (-1, 0)), ((5, 1), (-1, 0)), ((4, 1), (-1, 0)), ((3, 1), (-1, 0)), ((3, 12), (1, 0)),
                         ((4, 12), (0, -1)), ((4, 11), (0, -1)), ((4, 10), (0, -1)), ((4, 9), (1, 0)), ((5, 9), (1, 0)),
                         ((6, 9), (1, 0)), ((7, 9), (1, 0)), ((8, 9), (0, -1)), ((8, 8), (0, -1)), ((8, 7), (0, -1)),
                         ((8, 6), (0, -1)), ((8, 5), (0, -1)), ((8, 4), (0, -1)), ((8, 3), (0, -1)), ((8, 2), (0, -1)),
                         ((8, 1), (-1, 0)), ((7, 1), (-1, 0)), ((6, 1), (-1, 0)), ((5, 1), (-1, 0)), ((4, 1), (-1, 0)),
                         ((3, 1), (-1, 0)), ((2, 8), (0, -1)), ((2, 7), (0, -1)), ((2, 6), (0, -1)), ((2, 5), (0, 1)),
                         ((2, 6), (0, 1)), ((2, 7), (0, 1)), ((2, 8), (0, 1)), ((2, 9), (0, 1)), ((2, 10), (1, 0)),
                         ((3, 10), (0, -1)), ((3, 9), (1, 0)), ((4, 9), (1, 0)), ((5, 9), (1, 0)), ((6, 9), (1, 0)),
                         ((7, 9), (1, 0)), ((8, 9), (0, -1)), ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (0, -1)),
                         ((8, 5), (0, -1)), ((8, 4), (0, -1)), ((8, 3), (0, -1)), ((8, 2), (0, -1)), ((8, 1), (-1, 0)),
                         ((7, 1), (-1, 0)), ((6, 1), (-1, 0)), ((5, 1), (-1, 0)), ((4, 1), (-1, 0)), ((3, 1), (-1, 0)),
                         ((3, 5), (-1, 0)), ((2, 5), (0, 1)), ((2, 6), (0, 1)), ((2, 7), (0, 1)), ((2, 8), (0, 1)),
                         ((2, 9), (0, 1)), ((2, 10), (1, 0)), ((3, 10), (0, -1)), ((3, 9), (1, 0)), ((4, 9), (1, 0)),
                         ((5, 9), (1, 0)), ((6, 9), (1, 0)), ((7, 9), (1, 0)), ((8, 9), (0, -1)), ((8, 8), (0, -1)),
                         ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (0, -1)), ((8, 4), (0, -1)), ((8, 3), (0, -1)),
                         ((8, 2), (0, -1)), ((8, 1), (-1, 0)), ((7, 1), (-1, 0)), ((6, 1), (-1, 0)), ((5, 1), (-1, 0)),
                         ((4, 1), (-1, 0)), ((3, 1), (-1, 0)), ((3, 6), (-1, 0)), ((2, 6), (0, 1)), ((2, 7), (0, 1)),
                         ((2, 8), (0, 1)), ((2, 9), (0, 1)), ((2, 10), (1, 0)), ((3, 10), (0, -1)), ((3, 9), (1, 0)),
                         ((4, 9), (1, 0)), ((5, 9), (1, 0)), ((6, 9), (1, 0)), ((7, 9), (1, 0)), ((8, 9), (0, -1)),
                         ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (0, -1)), ((8, 4), (0, -1)),
                         ((8, 3), (0, -1)), ((8, 2), (0, -1)), ((8, 1), (-1, 0)), ((7, 1), (-1, 0)), ((6, 1), (-1, 0)),
                         ((5, 1), (-1, 0)), ((4, 1), (-1, 0)), ((3, 1), (-1, 0)), ((3, 7), (-1, 0)), ((2, 7), (0, 1)),
                         ((2, 8), (0, 1)), ((2, 9), (0, 1)), ((2, 10), (1, 0)), ((3, 10), (0, -1)), ((3, 9), (1, 0)),
                         ((4, 9), (1, 0)), ((5, 9), (1, 0)), ((6, 9), (1, 0)), ((7, 9), (1, 0)), ((8, 9), (0, -1)),
                         ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (0, -1)), ((8, 4), (0, -1)),
                         ((8, 3), (0, -1)), ((8, 2), (0, -1)), ((8, 1), (-1, 0)), ((7, 1), (-1, 0)), ((6, 1), (-1, 0)),
                         ((5, 1), (-1, 0)), ((4, 1), (-1, 0)), ((3, 1), (-1, 0))], '''\
     ------  ----- 
     |....|  |...| 
     |.0..----.0.| 
     |.0......0..| 
     |..--->---0.| 
     |---------.---
     |....^<|.....|
     |..----|0....|
     --.|   |.0...|
      |.-----.0...|
      |......0.0..|
      |??----------
      ----         ''': [((3, 10), (0, 1)), ((3, 11), (0, -1)), ((4, 11), (1, 0)), ((5, 11), (1, 0)), ((6, 11), (1, 0)),
                         ((9, 10), (0, -1)), ((10, 9), (0, -1)), ((10, 8), (0, -1)), ((10, 7), (0, -1)),
                         ((10, 6), (0, -1)), ((10, 5), (0, -1)), ((10, 4), (0, -1)), ((10, 3), (-1, 0)),
                         ((9, 3), (-1, 0)), ((8, 3), (-1, 0)), ((7, 3), (-1, 0)), ((6, 3), (0, 1)), ((6, 4), (0, 1)),
                         ((6, 5), (0, 1)), ((10, 11), (0, -1)), ((10, 10), (0, -1)), ((10, 9), (0, -1)),
                         ((10, 8), (0, -1)), ((10, 7), (0, -1)), ((10, 6), (0, -1)), ((10, 5), (0, -1)),
                         ((10, 4), (0, -1)), ((10, 3), (-1, 0)), ((9, 3), (-1, 0)), ((8, 3), (-1, 0)),
                         ((7, 3), (-1, 0)), ((6, 3), (0, 1)), ((6, 4), (0, 1)), ((6, 5), (0, 1)), ((8, 10), (1, 0)),
                         ((9, 10), (1, 0)), ((10, 10), (0, -1)), ((10, 9), (0, -1)), ((10, 8), (0, -1)),
                         ((10, 7), (0, -1)), ((10, 6), (0, -1)), ((10, 5), (0, -1)), ((10, 4), (0, -1)),
                         ((10, 3), (-1, 0)), ((9, 3), (-1, 0)), ((8, 3), (-1, 0)), ((7, 3), (-1, 0)), ((6, 3), (0, 1)),
                         ((6, 4), (0, 1)), ((6, 5), (0, 1)), ((9, 9), (1, 0)), ((10, 9), (0, -1)), ((10, 8), (0, -1)),
                         ((10, 7), (0, -1)), ((10, 6), (0, -1)), ((10, 5), (0, -1)), ((10, 4), (0, -1)),
                         ((10, 3), (-1, 0)), ((9, 3), (-1, 0)), ((8, 3), (-1, 0)), ((7, 3), (-1, 0)), ((6, 3), (0, 1)),
                         ((6, 4), (0, 1)), ((6, 5), (0, 1)), ((7, 11), (1, 0)), ((8, 11), (1, 0)), ((9, 11), (1, 0)),
                         ((10, 11), (0, -1)), ((10, 10), (0, -1)), ((10, 9), (0, -1)), ((10, 8), (0, -1)),
                         ((10, 7), (0, -1)), ((10, 6), (0, -1)), ((10, 5), (0, -1)), ((10, 4), (0, -1)),
                         ((10, 3), (-1, 0)), ((9, 3), (-1, 0)), ((8, 3), (-1, 0)), ((7, 3), (-1, 0)), ((6, 3), (0, 1)),
                         ((6, 4), (0, 1)), ((6, 5), (0, 1)), ((7, 9), (1, 0)), ((8, 9), (1, 0)), ((9, 9), (1, 0)),
                         ((10, 9), (0, -1)), ((10, 8), (0, -1)), ((10, 7), (0, -1)), ((10, 6), (0, -1)),
                         ((10, 5), (0, -1)), ((10, 4), (0, -1)), ((10, 3), (-1, 0)), ((9, 3), (-1, 0)),
                         ((8, 3), (-1, 0)), ((7, 3), (-1, 0)), ((6, 3), (0, 1)), ((6, 4), (0, 1)), ((6, 5), (0, 1)),
                         ((2, 11), (1, 0)), ((3, 11), (1, 0)), ((4, 11), (1, 0)), ((5, 11), (1, 0)), ((6, 11), (1, 0)),
                         ((7, 11), (1, 0)), ((8, 11), (1, 0)), ((9, 11), (1, 0)), ((10, 11), (0, -1)),
                         ((10, 10), (0, -1)), ((10, 9), (0, -1)), ((10, 8), (0, -1)), ((10, 7), (0, -1)),
                         ((10, 6), (0, -1)), ((10, 5), (0, -1)), ((10, 4), (0, -1)), ((10, 3), (-1, 0)),
                         ((9, 3), (-1, 0)), ((8, 3), (-1, 0)), ((7, 3), (-1, 0)), ((6, 3), (0, 1)), ((6, 4), (0, 1)),
                         ((6, 5), (0, 1)), ((3, 10), (0, -1)), ((3, 9), (0, -1)), ((3, 8), (0, -1)), ((3, 7), (0, -1)),
                         ((3, 6), (0, -1)), ((3, 5), (0, -1)), ((2, 3), (0, 1)), ((3, 3), (-1, 0)), ((3, 4), (0, 1)),
                         ((3, 5), (0, 1)), ((3, 6), (0, 1)), ((3, 7), (0, 1)), ((3, 8), (0, 1)), ((3, 9), (0, 1)),
                         ((3, 10), (0, 1)), ((3, 11), (1, 0)), ((4, 11), (1, 0)), ((5, 11), (1, 0)), ((6, 11), (1, 0)),
                         ((7, 11), (1, 0)), ((8, 11), (1, 0)), ((9, 11), (1, 0)), ((10, 11), (0, -1)),
                         ((10, 10), (0, -1)), ((10, 9), (0, -1)), ((10, 8), (0, -1)), ((10, 7), (0, -1)),
                         ((10, 6), (0, -1)), ((10, 5), (0, -1)), ((10, 4), (0, -1)), ((10, 3), (-1, 0)),
                         ((9, 3), (-1, 0)), ((8, 3), (-1, 0)), ((7, 3), (-1, 0)), ((6, 3), (0, 1)), ((6, 4), (0, 1)),
                         ((6, 5), (0, 1)), ((2, 4), (1, 0)), ((3, 4), (0, 1)), ((3, 5), (0, 1)), ((3, 6), (0, 1)),
                         ((3, 7), (0, 1)), ((3, 8), (0, 1)), ((3, 9), (0, 1)), ((3, 10), (0, 1)), ((3, 11), (1, 0)),
                         ((4, 11), (1, 0)), ((5, 11), (1, 0)), ((6, 11), (1, 0)), ((7, 11), (1, 0)), ((8, 11), (1, 0)),
                         ((9, 11), (1, 0)), ((10, 11), (0, -1)), ((10, 10), (0, -1)), ((10, 9), (0, -1)),
                         ((10, 8), (0, -1)), ((10, 7), (0, -1)), ((10, 6), (0, -1)), ((10, 5), (0, -1)),
                         ((10, 4), (0, -1)), ((10, 3), (-1, 0)), ((9, 3), (-1, 0)), ((8, 3), (-1, 0)),
                         ((7, 3), (-1, 0)), ((6, 3), (0, 1)), ((6, 4), (0, 1)), ((6, 5), (0, 1)), ((2, 3), (1, 0)),
                         ((3, 3), (0, 1)), ((3, 4), (0, 1)), ((3, 5), (0, 1)), ((3, 6), (0, 1)), ((3, 7), (0, 1)),
                         ((3, 8), (0, 1)), ((3, 9), (0, 1)), ((3, 10), (0, 1)), ((3, 11), (1, 0)), ((4, 11), (1, 0)),
                         ((5, 11), (1, 0)), ((6, 11), (1, 0)), ((7, 11), (1, 0)), ((8, 11), (1, 0)), ((9, 11), (1, 0)),
                         ((10, 11), (0, -1)), ((10, 10), (0, -1)), ((10, 9), (0, -1)), ((10, 8), (0, -1)),
                         ((10, 7), (0, -1)), ((10, 6), (0, -1)), ((10, 5), (0, -1)), ((10, 4), (0, -1)),
                         ((10, 3), (-1, 0)), ((9, 3), (-1, 0)), ((8, 3), (-1, 0)), ((7, 3), (-1, 0)), ((6, 3), (0, 1)),
                         ((6, 4), (0, 1)), ((6, 5), (0, 1))], '''\
      ----          -----------
     --.>--------   |.........|
     |..........|   |.........|
     |.0-----0-.|   |.........|
     |..|...|.0.|   |....<....|
     |.0.0....0-|   |.........|
     |.0..0..|..|   |.........|
     |.----0.--.|   |.........|
     |..0...0.|.--  |.........|
     |.---0-...0.------------+|
     |...|..0-.0............^.|
     |..0......----------------
     -----..|..|               
         -------               ''': [((3, 9), (1, 0)), ((4, 9), (1, 0)), ((4, 10), (0, -1)), ((11, 4), (0, 1)),
                                     ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (-1, 0)), ((10, 11), (0, 1)),
                                     ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)),
                                     ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)),
                                     ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)),
                                     ((10, 8), (1, 0)), ((9, 11), (0, -1)), ((5, 10), (-1, 0)), ((5, 9), (0, -1)),
                                     ((5, 8), (0, -1)), ((8, 8), (1, 0)), ((9, 10), (0, 1)), ((9, 11), (1, 0)),
                                     ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                     ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                     ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                     ((10, 23), (0, 1)), ((11, 8), (0, -1)), ((11, 7), (0, -1)), ((11, 6), (0, -1)),
                                     ((11, 5), (0, -1)), ((11, 4), (0, -1)), ((11, 3), (0, 1)), ((11, 4), (0, 1)),
                                     ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)), ((11, 8), (0, 1)),
                                     ((11, 9), (0, 1)), ((11, 10), (-1, 0)), ((10, 10), (-1, 0)), ((9, 10), (0, 1)),
                                     ((9, 11), (1, 0)), ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)),
                                     ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)),
                                     ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)),
                                     ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((9, 8), (1, 0)), ((10, 8), (1, 0)),
                                     ((11, 8), (0, -1)), ((11, 7), (0, -1)), ((11, 6), (0, -1)), ((11, 5), (0, -1)),
                                     ((11, 4), (0, -1)), ((11, 3), (0, 1)), ((11, 4), (0, 1)), ((11, 5), (0, 1)),
                                     ((11, 6), (0, 1)), ((11, 7), (0, 1)), ((11, 8), (0, 1)), ((11, 9), (0, 1)),
                                     ((11, 10), (-1, 0)), ((10, 10), (-1, 0)), ((9, 10), (0, 1)), ((9, 11), (1, 0)),
                                     ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                     ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                     ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                     ((10, 23), (0, 1)), ((9, 6), (1, 0)), ((10, 6), (1, 0)), ((11, 6), (0, -1)),
                                     ((11, 5), (0, -1)), ((11, 4), (0, -1)), ((11, 3), (0, 1)), ((11, 4), (0, 1)),
                                     ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)), ((11, 8), (0, 1)),
                                     ((11, 9), (0, 1)), ((11, 10), (-1, 0)), ((10, 10), (-1, 0)), ((9, 10), (0, 1)),
                                     ((9, 11), (1, 0)), ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)),
                                     ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)),
                                     ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)),
                                     ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((10, 7), (0, -1)), ((10, 6), (1, 0)),
                                     ((11, 6), (0, -1)), ((11, 5), (0, -1)), ((11, 4), (0, -1)), ((11, 3), (0, 1)),
                                     ((11, 4), (0, 1)), ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)),
                                     ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (-1, 0)), ((10, 10), (-1, 0)),
                                     ((9, 10), (0, 1)), ((9, 11), (1, 0)), ((10, 11), (0, 1)), ((10, 12), (0, 1)),
                                     ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)),
                                     ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)),
                                     ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((7, 7), (1, 0)),
                                     ((8, 7), (0, 1)), ((8, 8), (1, 0)), ((9, 8), (1, 0)), ((10, 8), (1, 0)),
                                     ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (-1, 0)), ((10, 10), (-1, 0)),
                                     ((9, 10), (0, 1)), ((9, 11), (1, 0)), ((10, 11), (0, 1)), ((10, 12), (0, 1)),
                                     ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)),
                                     ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)),
                                     ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((8, 4), (0, 1)),
                                     ((8, 5), (0, 1)), ((8, 6), (0, 1)), ((8, 7), (0, 1)), ((8, 8), (1, 0)),
                                     ((9, 8), (1, 0)), ((10, 8), (1, 0)), ((11, 8), (0, 1)), ((11, 9), (0, 1)),
                                     ((11, 10), (-1, 0)), ((10, 10), (-1, 0)), ((9, 10), (0, 1)), ((9, 11), (1, 0)),
                                     ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                     ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                     ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                     ((10, 23), (0, 1)), ((4, 9), (1, 0)), ((4, 10), (0, -1)), ((3, 3), (-1, 0)),
                                     ((6, 3), (0, 1)), ((5, 3), (-1, 0)), ((5, 5), (0, 1)), ((5, 7), (1, 0)),
                                     ((6, 7), (1, 0)), ((7, 7), (1, 0)), ((8, 7), (0, 1)), ((8, 8), (1, 0)),
                                     ((9, 8), (1, 0)), ((10, 8), (1, 0)), ((11, 8), (0, 1)), ((11, 9), (0, 1)),
                                     ((11, 10), (-1, 0)), ((10, 10), (-1, 0)), ((5, 9), (0, -1)), ((5, 8), (0, -1)),
                                     ((9, 10), (0, 1)), ((9, 11), (1, 0)), ((10, 11), (0, 1)), ((10, 12), (0, 1)),
                                     ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)),
                                     ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)),
                                     ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((5, 7), (1, 0)),
                                     ((6, 7), (1, 0)), ((7, 7), (1, 0)), ((8, 7), (0, 1)), ((8, 8), (1, 0)),
                                     ((9, 8), (1, 0)), ((10, 8), (1, 0)), ((11, 8), (0, 1)), ((11, 9), (0, 1)),
                                     ((11, 10), (-1, 0)), ((10, 10), (-1, 0)), ((9, 10), (0, 1)), ((9, 11), (1, 0)),
                                     ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                     ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                     ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                     ((10, 23), (0, 1)), ((6, 6), (0, 1)), ((6, 7), (0, 1)), ((6, 8), (1, 0)),
                                     ((7, 8), (1, 0)), ((8, 8), (1, 0)), ((9, 8), (1, 0)), ((10, 8), (1, 0)),
                                     ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (-1, 0)), ((10, 10), (-1, 0)),
                                     ((9, 10), (0, 1)), ((9, 11), (1, 0)), ((10, 11), (0, 1)), ((10, 12), (0, 1)),
                                     ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)),
                                     ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)),
                                     ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((6, 4), (0, 1)),
                                     ((6, 5), (0, 1)), ((6, 6), (0, 1)), ((6, 7), (0, 1)), ((6, 8), (1, 0)),
                                     ((7, 8), (1, 0)), ((8, 8), (1, 0)), ((9, 8), (1, 0)), ((10, 8), (1, 0)),
                                     ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (-1, 0)), ((10, 10), (-1, 0)),
                                     ((9, 10), (0, 1)), ((9, 11), (1, 0)), ((10, 11), (0, 1)), ((10, 12), (0, 1)),
                                     ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)),
                                     ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)),
                                     ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((5, 6), (1, 0)),
                                     ((6, 6), (0, 1)), ((6, 7), (0, 1)), ((6, 8), (1, 0)), ((7, 8), (1, 0)),
                                     ((8, 8), (1, 0)), ((9, 8), (1, 0)), ((10, 8), (1, 0)), ((11, 8), (0, 1)),
                                     ((11, 9), (0, 1)), ((11, 10), (-1, 0)), ((10, 10), (-1, 0)), ((9, 10), (0, 1)),
                                     ((9, 11), (1, 0)), ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)),
                                     ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)),
                                     ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)),
                                     ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((4, 3), (1, 0)), ((5, 3), (1, 0)),
                                     ((6, 3), (0, 1)), ((6, 4), (0, 1)), ((6, 5), (0, 1)), ((6, 6), (0, 1)),
                                     ((6, 7), (0, 1)), ((6, 8), (1, 0)), ((7, 8), (1, 0)), ((8, 8), (1, 0)),
                                     ((9, 8), (1, 0)), ((10, 8), (1, 0)), ((11, 8), (0, 1)), ((11, 9), (0, 1)),
                                     ((11, 10), (-1, 0)), ((10, 10), (-1, 0)), ((9, 10), (0, 1)), ((9, 11), (1, 0)),
                                     ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                     ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                     ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                     ((10, 23), (0, 1)), ((4, 9), (1, 0)), ((5, 9), (0, -1)), ((5, 8), (0, -1)),
                                     ((5, 7), (0, -1)), ((5, 6), (1, 0)), ((6, 6), (0, 1)), ((6, 7), (0, 1)),
                                     ((6, 8), (1, 0)), ((7, 8), (1, 0)), ((8, 8), (1, 0)), ((9, 8), (1, 0)),
                                     ((10, 8), (1, 0)), ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (-1, 0)),
                                     ((10, 10), (-1, 0)), ((9, 10), (0, 1)), ((9, 11), (1, 0)), ((10, 11), (0, 1)),
                                     ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)),
                                     ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)),
                                     ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)),
                                     ((2, 3), (1, 0)), ((3, 3), (1, 0)), ((4, 3), (1, 0)), ((5, 3), (1, 0)),
                                     ((6, 3), (0, 1)), ((6, 4), (0, 1)), ((6, 5), (0, 1)), ((6, 6), (0, 1)),
                                     ((6, 7), (0, 1)), ((6, 8), (1, 0)), ((7, 8), (1, 0)), ((8, 8), (1, 0)),
                                     ((9, 8), (1, 0)), ((10, 8), (1, 0)), ((11, 8), (0, 1)), ((11, 9), (0, 1)),
                                     ((11, 10), (-1, 0)), ((10, 10), (-1, 0)), ((9, 10), (0, 1)), ((9, 11), (1, 0)),
                                     ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                     ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                     ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                     ((10, 23), (0, 1))], '''\
     -----------       -----------
     |....|....---     |.........|
     |..00|00...>|     |.........|
     |.....0...---     |.........|
     |....|....|       |....<....|
     |-.---------      |.........|
     |..0.|.....|      |.........|
     |.00.|0.0.0|      |.........|
     |..0.....0.|      |.........|
     |.000|0..0.----------------+|
     |....|..0.0...............^.|
     -----------------------------''': [((3, 7), (0, -1)), ((3, 6), (0, -1)), ((3, 5), (0, -1)), ((8, 4), (0, 1)),
                                        ((8, 5), (0, 1)), ((8, 6), (0, 1)), ((8, 7), (0, 1)), ((8, 8), (0, 1)),
                                        ((9, 10), (0, 1)), ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)),
                                        ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)),
                                        ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)),
                                        ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((10, 24), (0, 1)), ((10, 25), (0, 1)),
                                        ((10, 26), (0, 1)), ((10, 9), (0, 1)), ((10, 10), (0, 1)), ((10, 11), (0, 1)),
                                        ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)),
                                        ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)),
                                        ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)),
                                        ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1)), ((8, 10), (1, 0)),
                                        ((9, 10), (1, 0)), ((10, 10), (0, 1)), ((10, 11), (0, 1)), ((10, 12), (0, 1)),
                                        ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)),
                                        ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)),
                                        ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((10, 24), (0, 1)),
                                        ((10, 25), (0, 1)), ((10, 26), (0, 1)), ((9, 11), (1, 0)), ((10, 11), (0, 1)),
                                        ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)),
                                        ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)),
                                        ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)),
                                        ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1)), ((7, 11), (1, 0)),
                                        ((8, 11), (1, 0)), ((9, 11), (1, 0)), ((10, 11), (0, 1)), ((10, 12), (0, 1)),
                                        ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)),
                                        ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)),
                                        ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((10, 24), (0, 1)),
                                        ((10, 25), (0, 1)), ((10, 26), (0, 1)), ((8, 9), (0, 1)), ((7, 9), (1, 0)),
                                        ((8, 9), (1, 0)), ((9, 9), (1, 0)), ((10, 9), (0, 1)), ((10, 10), (0, 1)),
                                        ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                        ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                        ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                        ((10, 23), (0, 1)), ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1)),
                                        ((8, 10), (1, 0)), ((9, 10), (1, 0)), ((10, 10), (0, 1)), ((10, 11), (0, 1)),
                                        ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)),
                                        ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)),
                                        ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)),
                                        ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1)), ((9, 3), (-1, 0)),
                                        ((8, 3), (0, 1)), ((8, 4), (0, 1)), ((8, 5), (0, 1)), ((8, 6), (0, 1)),
                                        ((8, 7), (0, 1)), ((8, 8), (0, 1)), ((8, 9), (0, 1)), ((8, 10), (1, 0)),
                                        ((9, 10), (1, 0)), ((10, 10), (0, 1)), ((10, 11), (0, 1)), ((10, 12), (0, 1)),
                                        ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)),
                                        ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)),
                                        ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((10, 24), (0, 1)),
                                        ((10, 25), (0, 1)), ((10, 26), (0, 1)), ((9, 4), (-1, 0)), ((8, 4), (0, 1)),
                                        ((8, 5), (0, 1)), ((8, 6), (0, 1)), ((8, 7), (0, 1)), ((8, 8), (0, 1)),
                                        ((8, 9), (0, 1)), ((8, 10), (1, 0)), ((9, 10), (1, 0)), ((10, 10), (0, 1)),
                                        ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                        ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                        ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                        ((10, 23), (0, 1)), ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1)),
                                        ((9, 5), (-1, 0)), ((8, 5), (0, 1)), ((8, 6), (0, 1)), ((8, 7), (0, 1)),
                                        ((8, 8), (0, 1)), ((8, 9), (1, 0)), ((9, 9), (1, 0)), ((10, 9), (0, 1)),
                                        ((10, 10), (0, 1)), ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)),
                                        ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)),
                                        ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)),
                                        ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((10, 24), (0, 1)), ((10, 25), (0, 1)),
                                        ((10, 26), (0, 1)), ((7, 3), (1, 0)), ((8, 3), (0, 1)), ((8, 4), (0, 1)),
                                        ((8, 5), (0, 1)), ((8, 6), (0, 1)), ((8, 7), (0, 1)), ((8, 8), (0, 1)),
                                        ((8, 9), (0, 1)), ((8, 10), (1, 0)), ((9, 10), (1, 0)), ((10, 10), (0, 1)),
                                        ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                        ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                        ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                        ((10, 23), (0, 1)), ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1)),
                                        ((3, 4), (0, -1)), ((3, 3), (1, 0)), ((4, 3), (1, 0)), ((5, 3), (1, 0)),
                                        ((6, 3), (1, 0)), ((7, 3), (1, 0)), ((8, 3), (0, 1)), ((8, 4), (0, 1)),
                                        ((8, 5), (0, 1)), ((8, 6), (0, 1)), ((8, 7), (0, 1)), ((8, 8), (0, 1)),
                                        ((8, 9), (0, 1)), ((8, 10), (1, 0)), ((9, 10), (1, 0)), ((10, 10), (0, 1)),
                                        ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                        ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                        ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                        ((10, 23), (0, 1)), ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1)),
                                        ((7, 4), (0, -1)), ((7, 3), (1, 0)), ((8, 3), (0, 1)), ((8, 4), (0, 1)),
                                        ((8, 5), (0, 1)), ((8, 6), (0, 1)), ((8, 7), (0, 1)), ((8, 8), (0, 1)),
                                        ((8, 9), (0, 1)), ((8, 10), (1, 0)), ((9, 10), (1, 0)), ((10, 10), (0, 1)),
                                        ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                        ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                        ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                        ((10, 23), (0, 1)), ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1)),
                                        ((2, 4), (1, 0)), ((3, 4), (0, -1)), ((3, 3), (1, 0)), ((4, 3), (1, 0)),
                                        ((5, 3), (1, 0)), ((6, 3), (1, 0)), ((7, 3), (1, 0)), ((8, 3), (0, 1)),
                                        ((8, 4), (0, 1)), ((8, 5), (0, 1)), ((8, 6), (0, 1)), ((8, 7), (0, 1)),
                                        ((8, 8), (0, 1)), ((8, 9), (0, 1)), ((8, 10), (1, 0)), ((9, 10), (1, 0)),
                                        ((10, 10), (0, 1)), ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)),
                                        ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)),
                                        ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)),
                                        ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((10, 24), (0, 1)), ((10, 25), (0, 1)),
                                        ((10, 26), (0, 1)), ((2, 8), (1, 0)), ((3, 8), (0, -1)), ((3, 7), (0, -1)),
                                        ((3, 6), (0, -1)), ((3, 5), (0, -1)), ((3, 4), (0, -1)), ((3, 3), (1, 0)),
                                        ((4, 3), (1, 0)), ((5, 3), (1, 0)), ((6, 3), (1, 0)), ((7, 3), (1, 0)),
                                        ((8, 3), (0, 1)), ((8, 4), (0, 1)), ((8, 5), (0, 1)), ((8, 6), (0, 1)),
                                        ((8, 7), (0, 1)), ((8, 8), (0, 1)), ((8, 9), (0, 1)), ((8, 10), (1, 0)),
                                        ((9, 10), (1, 0)), ((10, 10), (0, 1)), ((10, 11), (0, 1)), ((10, 12), (0, 1)),
                                        ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)),
                                        ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)),
                                        ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((10, 24), (0, 1)),
                                        ((10, 25), (0, 1)), ((10, 26), (0, 1)), ((2, 7), (1, 0)), ((3, 7), (0, -1)),
                                        ((3, 6), (0, -1)), ((3, 5), (0, -1)), ((3, 4), (0, -1)), ((3, 3), (1, 0)),
                                        ((4, 3), (1, 0)), ((5, 3), (1, 0)), ((6, 3), (1, 0)), ((7, 3), (1, 0)),
                                        ((8, 3), (0, 1)), ((8, 4), (0, 1)), ((8, 5), (0, 1)), ((8, 6), (0, 1)),
                                        ((8, 7), (0, 1)), ((8, 8), (0, 1)), ((8, 9), (0, 1)), ((8, 10), (1, 0)),
                                        ((9, 10), (1, 0)), ((10, 10), (0, 1)), ((10, 11), (0, 1)), ((10, 12), (0, 1)),
                                        ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)), ((10, 16), (0, 1)),
                                        ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)), ((10, 20), (0, 1)),
                                        ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)), ((10, 24), (0, 1)),
                                        ((10, 25), (0, 1)), ((10, 26), (0, 1)), ((9, 7), (-1, 0)), ((8, 7), (0, -1)),
                                        ((8, 6), (0, -1)), ((8, 5), (0, -1)), ((8, 4), (0, 1)), ((8, 5), (0, 1)),
                                        ((8, 6), (0, 1)), ((8, 7), (0, 1)), ((8, 8), (0, 1)), ((8, 9), (1, 0)),
                                        ((9, 9), (1, 0)), ((10, 9), (0, 1)), ((10, 10), (0, 1)), ((10, 11), (0, 1)),
                                        ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)),
                                        ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)),
                                        ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)),
                                        ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1)), ((7, 7), (1, 0)),
                                        ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (0, -1)), ((8, 4), (0, 1)),
                                        ((8, 5), (0, 1)), ((8, 6), (0, 1)), ((8, 7), (0, 1)), ((8, 8), (1, 0)),
                                        ((9, 8), (1, 0)), ((10, 8), (0, 1)), ((10, 9), (0, 1)), ((10, 10), (0, 1)),
                                        ((10, 11), (0, 1)), ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)),
                                        ((10, 15), (0, 1)), ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)),
                                        ((10, 19), (0, 1)), ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)),
                                        ((10, 23), (0, 1)), ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1)),
                                        ((6, 4), (0, -1)), ((6, 3), (-1, 0)), ((5, 3), (-1, 0)), ((4, 3), (-1, 0)),
                                        ((3, 3), (1, 0)), ((4, 3), (1, 0)), ((5, 3), (1, 0)), ((6, 3), (1, 0)),
                                        ((7, 3), (1, 0)), ((8, 3), (0, 1)), ((8, 4), (0, 1)), ((8, 5), (0, 1)),
                                        ((8, 6), (0, 1)), ((8, 7), (0, 1)), ((8, 8), (0, 1)), ((8, 9), (0, 1)),
                                        ((8, 10), (1, 0)), ((9, 10), (1, 0)), ((10, 10), (0, 1)), ((10, 11), (0, 1)),
                                        ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)),
                                        ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)),
                                        ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)),
                                        ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1)), ((2, 5), (1, 0)),
                                        ((3, 5), (0, 1)), ((3, 6), (0, 1)), ((3, 7), (0, 1)), ((3, 8), (0, -1)),
                                        ((3, 7), (0, -1)), ((3, 6), (0, -1)), ((3, 5), (0, -1)), ((3, 4), (0, -1)),
                                        ((3, 3), (1, 0)), ((4, 3), (1, 0)), ((5, 3), (1, 0)), ((6, 3), (1, 0)),
                                        ((7, 3), (1, 0)), ((8, 3), (0, 1)), ((8, 4), (0, 1)), ((8, 5), (0, 1)),
                                        ((8, 6), (0, 1)), ((8, 7), (0, 1)), ((8, 8), (0, 1)), ((8, 9), (0, 1)),
                                        ((8, 10), (1, 0)), ((9, 10), (1, 0)), ((10, 10), (0, 1)), ((10, 11), (0, 1)),
                                        ((10, 12), (0, 1)), ((10, 13), (0, 1)), ((10, 14), (0, 1)), ((10, 15), (0, 1)),
                                        ((10, 16), (0, 1)), ((10, 17), (0, 1)), ((10, 18), (0, 1)), ((10, 19), (0, 1)),
                                        ((10, 20), (0, 1)), ((10, 21), (0, 1)), ((10, 22), (0, 1)), ((10, 23), (0, 1)),
                                        ((10, 24), (0, 1)), ((10, 25), (0, 1)), ((10, 26), (0, 1))], '''\
       --------          
     ---.|....|          
     |...0....|----------
     |.-.00-00|.|.......|
     |.00-......|.......|
     |.-..0.|...|.......|
     |....-0--0-|...<...|
     |..00..0...|.......|
     |.--...|...|.......|
     |....-0|---|.......|
     ---..0.-----------+|
       |..0>..........^.|
       ------------------''': [((10, 6), (0, -1)), ((10, 5), (0, -1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)),
                               ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)), ((11, 11), (0, 1)),
                               ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)), ((11, 15), (0, 1)),
                               ((11, 16), (0, 1)), ((11, 17), (0, 1)), ((9, 7), (1, 0)), ((10, 7), (1, 0)),
                               ((11, 7), (0, 1)), ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)),
                               ((11, 11), (0, 1)), ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)),
                               ((11, 15), (0, 1)), ((11, 16), (0, 1)), ((11, 17), (0, 1)), ((7, 5), (-1, 0)),
                               ((10, 4), (-1, 0)), ((7, 4), (0, -1)), ((9, 4), (0, 1)), ((9, 5), (1, 0)),
                               ((10, 5), (1, 0)), ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)),
                               ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)), ((11, 11), (0, 1)),
                               ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)), ((11, 15), (0, 1)),
                               ((11, 16), (0, 1)), ((11, 17), (0, 1)), ((6, 5), (1, 0)), ((7, 5), (1, 0)),
                               ((8, 5), (1, 0)), ((9, 5), (1, 0)), ((10, 5), (1, 0)), ((11, 5), (0, 1)),
                               ((11, 6), (0, 1)), ((11, 7), (0, 1)), ((11, 8), (0, 1)), ((11, 9), (0, 1)),
                               ((11, 10), (0, 1)), ((11, 11), (0, 1)), ((11, 12), (0, 1)), ((11, 13), (0, 1)),
                               ((11, 14), (0, 1)), ((11, 15), (0, 1)), ((11, 16), (0, 1)), ((11, 17), (0, 1)),
                               ((7, 3), (0, 1)), ((7, 4), (0, 1)), ((7, 5), (1, 0)), ((8, 5), (1, 0)), ((9, 5), (1, 0)),
                               ((10, 5), (1, 0)), ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)),
                               ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)), ((11, 11), (0, 1)),
                               ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)), ((11, 15), (0, 1)),
                               ((11, 16), (0, 1)), ((11, 17), (0, 1)), ((4, 4), (1, 0)), ((5, 4), (1, 0)),
                               ((6, 4), (1, 0)), ((7, 4), (0, 1)), ((7, 5), (1, 0)), ((8, 5), (1, 0)), ((9, 5), (1, 0)),
                               ((10, 5), (1, 0)), ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)),
                               ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)), ((11, 11), (0, 1)),
                               ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)), ((11, 15), (0, 1)),
                               ((11, 16), (0, 1)), ((11, 17), (0, 1)), ((4, 3), (0, 1)), ((4, 4), (1, 0)),
                               ((5, 4), (1, 0)), ((6, 4), (1, 0)), ((7, 4), (0, 1)), ((7, 5), (1, 0)), ((8, 5), (1, 0)),
                               ((9, 5), (1, 0)), ((10, 5), (1, 0)), ((11, 5), (0, 1)), ((11, 6), (0, 1)),
                               ((11, 7), (0, 1)), ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)),
                               ((11, 11), (0, 1)), ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)),
                               ((11, 15), (0, 1)), ((11, 16), (0, 1)), ((11, 17), (0, 1)), ((7, 8), (0, 1)),
                               ((7, 9), (0, 1)), ((7, 10), (0, -1)), ((7, 9), (0, -1)), ((7, 8), (0, -1)),
                               ((7, 7), (0, -1)), ((7, 6), (0, -1)), ((7, 5), (1, 0)), ((8, 5), (1, 0)),
                               ((9, 5), (1, 0)), ((10, 5), (1, 0)), ((11, 5), (0, 1)), ((11, 6), (0, 1)),
                               ((11, 7), (0, 1)), ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)),
                               ((11, 11), (0, 1)), ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)),
                               ((11, 15), (0, 1)), ((11, 16), (0, 1)), ((11, 17), (0, 1)), ((6, 7), (-1, 0)),
                               ((5, 7), (-1, 0)), ((5, 6), (0, -1)), ((5, 5), (0, -1)), ((5, 4), (1, 0)),
                               ((6, 4), (1, 0)), ((7, 4), (0, 1)), ((7, 5), (1, 0)), ((8, 5), (1, 0)), ((9, 5), (1, 0)),
                               ((10, 5), (1, 0)), ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)),
                               ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)), ((11, 11), (0, 1)),
                               ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)), ((11, 15), (0, 1)),
                               ((11, 16), (0, 1)), ((11, 17), (0, 1)), ((2, 5), (0, 1)), ((2, 6), (0, 1)),
                               ((3, 6), (1, 0)), ((4, 6), (1, 0)), ((5, 6), (0, -1)), ((5, 5), (0, -1)),
                               ((5, 4), (1, 0)), ((6, 4), (1, 0)), ((7, 4), (0, 1)), ((7, 5), (0, 1)), ((7, 6), (0, 1)),
                               ((7, 7), (1, 0)), ((8, 7), (1, 0)), ((9, 7), (1, 0)), ((10, 7), (1, 0)),
                               ((11, 7), (0, 1)), ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)),
                               ((11, 11), (0, 1)), ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)),
                               ((11, 15), (0, 1)), ((11, 16), (0, 1)), ((11, 17), (0, 1)), ((3, 5), (0, -1)),
                               ((3, 4), (1, 0)), ((4, 4), (1, 0)), ((5, 4), (1, 0)), ((6, 4), (1, 0)), ((7, 4), (0, 1)),
                               ((7, 5), (1, 0)), ((8, 5), (1, 0)), ((9, 5), (1, 0)), ((10, 5), (1, 0)),
                               ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)), ((11, 8), (0, 1)),
                               ((11, 9), (0, 1)), ((11, 10), (0, 1)), ((11, 11), (0, 1)), ((11, 12), (0, 1)),
                               ((11, 13), (0, 1)), ((11, 14), (0, 1)), ((11, 15), (0, 1)), ((11, 16), (0, 1)),
                               ((11, 17), (0, 1)), ((6, 10), (-1, 0)), ((5, 10), (-1, 0)), ((4, 7), (0, -1)),
                               ((4, 6), (1, 0)), ((5, 6), (0, -1)), ((5, 5), (0, -1)), ((5, 4), (1, 0)),
                               ((6, 4), (1, 0)), ((7, 4), (0, 1)), ((7, 5), (1, 0)), ((8, 5), (1, 0)), ((9, 5), (1, 0)),
                               ((10, 5), (1, 0)), ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)),
                               ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)), ((11, 11), (0, 1)),
                               ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)), ((11, 15), (0, 1)),
                               ((11, 16), (0, 1)), ((11, 17), (0, 1)), ((4, 10), (0, -1)), ((4, 9), (0, -1)),
                               ((4, 8), (0, -1)), ((4, 7), (0, -1)), ((4, 6), (1, 0)), ((5, 6), (0, -1)),
                               ((5, 5), (0, -1)), ((5, 4), (1, 0)), ((6, 4), (1, 0)), ((7, 4), (0, 1)),
                               ((7, 5), (1, 0)), ((8, 5), (1, 0)), ((9, 5), (1, 0)), ((10, 5), (1, 0)),
                               ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)), ((11, 8), (0, 1)),
                               ((11, 9), (0, 1)), ((11, 10), (0, 1)), ((11, 11), (0, 1)), ((11, 12), (0, 1)),
                               ((11, 13), (0, 1)), ((11, 14), (0, 1)), ((11, 15), (0, 1)), ((11, 16), (0, 1)),
                               ((11, 17), (0, 1)), ((2, 7), (0, -1)), ((2, 6), (1, 0)), ((3, 6), (1, 0)),
                               ((4, 6), (1, 0)), ((5, 6), (0, -1)), ((5, 5), (0, -1)), ((5, 4), (1, 0)),
                               ((6, 4), (1, 0)), ((7, 4), (0, 1)), ((7, 5), (1, 0)), ((8, 5), (1, 0)), ((9, 5), (1, 0)),
                               ((10, 5), (1, 0)), ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)),
                               ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)), ((11, 11), (0, 1)),
                               ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)), ((11, 15), (0, 1)),
                               ((11, 16), (0, 1)), ((11, 17), (0, 1)), ((3, 9), (1, 0)), ((4, 9), (0, -1)),
                               ((4, 8), (0, -1)), ((4, 7), (0, -1)), ((4, 6), (1, 0)), ((5, 6), (0, -1)),
                               ((5, 5), (0, -1)), ((5, 4), (1, 0)), ((6, 4), (1, 0)), ((7, 4), (0, 1)),
                               ((7, 5), (1, 0)), ((8, 5), (1, 0)), ((9, 5), (1, 0)), ((10, 5), (1, 0)),
                               ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)), ((11, 8), (0, 1)),
                               ((11, 9), (0, 1)), ((11, 10), (0, 1)), ((11, 11), (0, 1)), ((11, 12), (0, 1)),
                               ((11, 13), (0, 1)), ((11, 14), (0, 1)), ((11, 15), (0, 1)), ((11, 16), (0, 1)),
                               ((11, 17), (0, 1)), ((3, 8), (1, 0)), ((4, 8), (0, -1)), ((4, 7), (0, -1)),
                               ((4, 6), (1, 0)), ((5, 6), (0, -1)), ((5, 5), (0, -1)), ((5, 4), (1, 0)),
                               ((6, 4), (1, 0)), ((7, 4), (0, 1)), ((7, 5), (1, 0)), ((8, 5), (1, 0)), ((9, 5), (1, 0)),
                               ((10, 5), (1, 0)), ((11, 5), (0, 1)), ((11, 6), (0, 1)), ((11, 7), (0, 1)),
                               ((11, 8), (0, 1)), ((11, 9), (0, 1)), ((11, 10), (0, 1)), ((11, 11), (0, 1)),
                               ((11, 12), (0, 1)), ((11, 13), (0, 1)), ((11, 14), (0, 1)), ((11, 15), (0, 1)),
                               ((11, 16), (0, 1)), ((11, 17), (0, 1))], '''\
     --------------------
     |........|...|.....|
     |.00..-00|.-.|.....|
     |..|.0.0.|00.|.....|
     |-.|..-..|.-.|..<..|
     |...--.......|.....|
     |...|.0.-...-|.....|
     |.0.|0.|...--|.....|
     |-0.|..-----------+|
     |..0.............^.|
     |...|.>-------------
     --------            ''': [((9, 4), (0, -1)), ((9, 3), (0, 1)), ((9, 4), (0, 1)), ((9, 5), (0, 1)),
                               ((9, 6), (0, 1)), ((9, 7), (0, 1)), ((9, 8), (0, 1)), ((9, 9), (0, 1)),
                               ((9, 10), (0, 1)), ((9, 11), (0, 1)), ((9, 12), (0, 1)), ((9, 13), (0, 1)),
                               ((9, 14), (0, 1)), ((9, 15), (0, 1)), ((9, 16), (0, 1)), ((9, 17), (0, 1)),
                               ((7, 3), (0, 1)), ((8, 3), (1, 0)), ((9, 3), (0, 1)), ((9, 4), (0, 1)), ((9, 5), (0, 1)),
                               ((9, 6), (0, 1)), ((9, 7), (0, 1)), ((9, 8), (0, 1)), ((9, 9), (0, 1)),
                               ((9, 10), (0, 1)), ((9, 11), (0, 1)), ((9, 12), (0, 1)), ((9, 13), (0, 1)),
                               ((9, 14), (0, 1)), ((9, 15), (0, 1)), ((9, 16), (0, 1)), ((9, 17), (0, 1)),
                               ((7, 4), (1, 0)), ((8, 4), (1, 0)), ((9, 4), (0, 1)), ((9, 5), (0, 1)), ((9, 6), (0, 1)),
                               ((9, 7), (0, 1)), ((9, 8), (0, 1)), ((9, 9), (0, 1)), ((9, 10), (0, 1)),
                               ((9, 11), (0, 1)), ((9, 12), (0, 1)), ((9, 13), (0, 1)), ((9, 14), (0, 1)),
                               ((9, 15), (0, 1)), ((9, 16), (0, 1)), ((9, 17), (0, 1)), ((2, 3), (1, 0)),
                               ((3, 3), (1, 0)), ((4, 3), (1, 0)), ((5, 3), (1, 0)), ((6, 3), (1, 0)), ((7, 3), (1, 0)),
                               ((8, 3), (1, 0)), ((9, 3), (0, 1)), ((9, 4), (0, 1)), ((9, 5), (0, 1)), ((9, 6), (0, 1)),
                               ((9, 7), (0, 1)), ((9, 8), (0, 1)), ((9, 9), (0, 1)), ((9, 10), (0, 1)),
                               ((9, 11), (0, 1)), ((9, 12), (0, 1)), ((9, 13), (0, 1)), ((9, 14), (0, 1)),
                               ((9, 15), (0, 1)), ((9, 16), (0, 1)), ((9, 17), (0, 1)), ((2, 4), (0, -1)),
                               ((2, 3), (1, 0)), ((3, 3), (1, 0)), ((4, 3), (1, 0)), ((5, 3), (1, 0)), ((6, 3), (1, 0)),
                               ((7, 3), (1, 0)), ((8, 3), (1, 0)), ((9, 3), (0, 1)), ((9, 4), (0, 1)), ((9, 5), (0, 1)),
                               ((9, 6), (0, 1)), ((9, 7), (0, 1)), ((9, 8), (0, 1)), ((9, 9), (0, 1)),
                               ((9, 10), (0, 1)), ((9, 11), (0, 1)), ((9, 12), (0, 1)), ((9, 13), (0, 1)),
                               ((9, 14), (0, 1)), ((9, 15), (0, 1)), ((9, 16), (0, 1)), ((9, 17), (0, 1)),
                               ((2, 9), (1, 0)), ((3, 9), (1, 0)), ((4, 9), (1, 0)), ((6, 7), (1, 0)), ((7, 7), (1, 0)),
                               ((8, 7), (1, 0)), ((9, 7), (0, 1)), ((9, 8), (0, 1)), ((9, 9), (0, 1)),
                               ((9, 10), (0, 1)), ((9, 11), (0, 1)), ((9, 12), (0, 1)), ((9, 13), (0, 1)),
                               ((9, 14), (0, 1)), ((9, 15), (0, 1)), ((9, 16), (0, 1)), ((9, 17), (0, 1)),
                               ((7, 6), (1, 0)), ((8, 6), (1, 0)), ((9, 6), (0, 1)), ((9, 7), (0, 1)), ((9, 8), (0, 1)),
                               ((9, 9), (0, 1)), ((9, 10), (0, 1)), ((9, 11), (0, 1)), ((9, 12), (0, 1)),
                               ((9, 13), (0, 1)), ((9, 14), (0, 1)), ((9, 15), (0, 1)), ((9, 16), (0, 1)),
                               ((9, 17), (0, 1)), ((5, 9), (0, 1)), ((5, 10), (0, 1)), ((5, 11), (0, -1)),
                               ((5, 10), (0, -1)), ((5, 9), (0, -1)), ((3, 6), (-1, 0)), ((3, 8), (0, -1)),
                               ((3, 7), (0, -1)), ((3, 6), (0, -1)), ((3, 5), (-1, 0)), ((2, 6), (1, 0)),
                               ((2, 5), (0, -1)), ((2, 4), (0, -1)), ((2, 3), (1, 0)), ((3, 3), (1, 0)),
                               ((4, 3), (1, 0)), ((5, 3), (1, 0)), ((6, 3), (1, 0)), ((7, 3), (1, 0)), ((8, 3), (1, 0)),
                               ((9, 3), (0, 1)), ((9, 4), (0, 1)), ((9, 5), (0, 1)), ((9, 6), (0, 1)), ((9, 7), (0, 1)),
                               ((9, 8), (0, 1)), ((9, 9), (0, 1)), ((9, 10), (0, 1)), ((9, 11), (0, 1)),
                               ((9, 12), (0, 1)), ((9, 13), (0, 1)), ((9, 14), (0, 1)), ((9, 15), (0, 1)),
                               ((9, 16), (0, 1)), ((9, 17), (0, 1)), ((3, 6), (0, -1)), ((3, 5), (-1, 0)),
                               ((2, 5), (0, -1)), ((2, 4), (0, -1)), ((2, 3), (1, 0)), ((3, 3), (1, 0)),
                               ((4, 3), (1, 0)), ((5, 3), (1, 0)), ((6, 3), (1, 0)), ((7, 3), (1, 0)), ((8, 3), (1, 0)),
                               ((9, 3), (0, 1)), ((9, 4), (0, 1)), ((9, 5), (0, 1)), ((9, 6), (0, 1)), ((9, 7), (0, 1)),
                               ((9, 8), (0, 1)), ((9, 9), (0, 1)), ((9, 10), (0, 1)), ((9, 11), (0, 1)),
                               ((9, 12), (0, 1)), ((9, 13), (0, 1)), ((9, 14), (0, 1)), ((9, 15), (0, 1)),
                               ((9, 16), (0, 1)), ((9, 17), (0, 1)), ((2, 8), (1, 0)), ((3, 8), (0, -1)),
                               ((3, 7), (0, -1)), ((3, 6), (0, -1)), ((3, 5), (-1, 0)), ((2, 5), (0, -1)),
                               ((2, 4), (0, -1)), ((2, 3), (1, 0)), ((3, 3), (1, 0)), ((4, 3), (1, 0)),
                               ((5, 3), (1, 0)), ((6, 3), (1, 0)), ((7, 3), (1, 0)), ((8, 3), (1, 0)), ((9, 3), (0, 1)),
                               ((9, 4), (0, 1)), ((9, 5), (0, 1)), ((9, 6), (0, 1)), ((9, 7), (0, 1)), ((9, 8), (0, 1)),
                               ((9, 9), (0, 1)), ((9, 10), (0, 1)), ((9, 11), (0, 1)), ((9, 12), (0, 1)),
                               ((9, 13), (0, 1)), ((9, 14), (0, 1)), ((9, 15), (0, 1)), ((9, 16), (0, 1)),
                               ((9, 17), (0, 1)), ((5, 8), (-1, 0)), ((4, 8), (-1, 0)), ((3, 8), (0, -1)),
                               ((3, 7), (0, -1)), ((3, 6), (0, -1)), ((3, 5), (-1, 0)), ((2, 5), (0, -1)),
                               ((2, 4), (0, -1)), ((2, 3), (1, 0)), ((3, 3), (1, 0)), ((4, 3), (1, 0)),
                               ((5, 3), (1, 0)), ((6, 3), (1, 0)), ((7, 3), (1, 0)), ((8, 3), (1, 0)), ((9, 3), (0, 1)),
                               ((9, 4), (0, 1)), ((9, 5), (0, 1)), ((9, 6), (0, 1)), ((9, 7), (0, 1)), ((9, 8), (0, 1)),
                               ((9, 9), (0, 1)), ((9, 10), (0, 1)), ((9, 11), (0, 1)), ((9, 12), (0, 1)),
                               ((9, 13), (0, 1)), ((9, 14), (0, 1)), ((9, 15), (0, 1)), ((9, 16), (0, 1)),
                               ((9, 17), (0, 1)), ((3, 11), (1, 0)), ((4, 11), (1, 0)), ((5, 11), (0, -1)),
                               ((5, 10), (0, -1)), ((5, 9), (0, -1)), ((5, 8), (-1, 0)), ((4, 8), (-1, 0)),
                               ((3, 8), (0, -1)), ((3, 7), (0, -1)), ((3, 6), (0, -1)), ((3, 5), (-1, 0)),
                               ((2, 5), (0, -1)), ((2, 4), (0, -1)), ((2, 3), (1, 0)), ((3, 3), (1, 0)),
                               ((4, 3), (1, 0)), ((5, 3), (1, 0)), ((6, 3), (1, 0)), ((7, 3), (1, 0)), ((8, 3), (1, 0)),
                               ((9, 3), (0, 1)), ((9, 4), (0, 1)), ((9, 5), (0, 1)), ((9, 6), (0, 1)), ((9, 7), (0, 1)),
                               ((9, 8), (0, 1)), ((9, 9), (0, 1)), ((9, 10), (0, 1)), ((9, 11), (0, 1)),
                               ((9, 12), (0, 1)), ((9, 13), (0, 1)), ((9, 14), (0, 1)), ((9, 15), (0, 1)),
                               ((9, 16), (0, 1)), ((9, 17), (0, 1)), ((3, 12), (0, -1)), ((3, 11), (1, 0)),
                               ((4, 11), (1, 0)), ((5, 11), (0, -1)), ((5, 10), (0, -1)), ((5, 9), (0, -1)),
                               ((5, 8), (-1, 0)), ((4, 8), (-1, 0)), ((3, 8), (0, -1)), ((3, 7), (0, -1)),
                               ((3, 6), (0, -1)), ((3, 5), (-1, 0)), ((2, 5), (0, -1)), ((2, 4), (0, -1)),
                               ((2, 3), (1, 0)), ((3, 3), (1, 0)), ((4, 3), (1, 0)), ((5, 3), (1, 0)), ((6, 3), (1, 0)),
                               ((7, 3), (1, 0)), ((8, 3), (1, 0)), ((9, 3), (0, 1)), ((9, 4), (0, 1)), ((9, 5), (0, 1)),
                               ((9, 6), (0, 1)), ((9, 7), (0, 1)), ((9, 8), (0, 1)), ((9, 9), (0, 1)),
                               ((9, 10), (0, 1)), ((9, 11), (0, 1)), ((9, 12), (0, 1)), ((9, 13), (0, 1)),
                               ((9, 14), (0, 1)), ((9, 15), (0, 1)), ((9, 16), (0, 1)), ((9, 17), (0, 1))], '''\
     --------------------------
     |>.....................^.|
     |.......----------------.|
     -------.------         |.|
      |...........|         |.|
      |.0.0.0.0.0.|         |.|
     --------.----|         |.|
     |...0.0..0.0.|         |.|
     |...0........|         |.|
     -----.--------   ------|.|
      |..0.0.0...|  --|.....|.|
      |.....0....|  |.+.....|.|
      |.0.0...0.--  |-|.....|.|
     -------.----   |.+.....+.|
     |..0.....|     |-|.....|--
     |........|     |.+.....|  
     |...------     --|.....|  
     -----            -------  ''': [((11, 8), (0, 1)), ((10, 9), (0, 1)), ((10, 10), (0, 1)), ((12, 10), (0, -1)),
                                     ((12, 9), (0, -1)), ((12, 8), (1, 0)), ((13, 8), (1, 0)), ((14, 8), (1, 0)),
                                     ((15, 8), (0, -1)), ((15, 7), (0, -1)), ((15, 6), (0, -1)), ((15, 5), (0, -1)),
                                     ((15, 4), (0, -1)), ((14, 4), (0, 1)), ((15, 3), (-1, 0)), ((7, 5), (0, -1)),
                                     ((7, 4), (0, -1)), ((10, 5), (0, -1)), ((8, 5), (0, 1)), ((8, 6), (1, 0)),
                                     ((9, 6), (1, 0)), ((10, 6), (1, 0)), ((11, 6), (0, 1)), ((11, 7), (0, 1)),
                                     ((11, 8), (1, 0)), ((12, 8), (1, 0)), ((13, 8), (1, 0)), ((14, 8), (1, 0)),
                                     ((14, 5), (0, 1)), ((14, 3), (0, 1)), ((15, 8), (0, -1)), ((15, 7), (0, -1)),
                                     ((15, 6), (0, -1)), ((15, 5), (0, -1)), ((14, 6), (0, 1)), ((15, 4), (0, -1)),
                                     ((14, 4), (0, 1)), ((15, 3), (-1, 0)), ((7, 7), (0, -1)), ((7, 6), (0, -1)),
                                     ((7, 10), (0, -1)), ((7, 9), (0, -1)), ((5, 10), (0, -1)), ((5, 9), (1, 0)),
                                     ((6, 9), (1, 0)), ((7, 9), (1, 0)), ((8, 9), (0, -1)), ((8, 8), (0, -1)),
                                     ((8, 7), (0, -1)), ((8, 6), (1, 0)), ((9, 6), (1, 0)), ((10, 6), (1, 0)),
                                     ((11, 6), (0, 1)), ((11, 7), (0, 1)), ((11, 8), (1, 0)), ((12, 8), (1, 0)),
                                     ((13, 8), (1, 0)), ((14, 8), (1, 0)), ((15, 8), (0, -1)), ((15, 7), (0, -1)),
                                     ((15, 6), (0, -1)), ((15, 5), (0, -1)), ((15, 4), (0, -1)), ((5, 8), (0, 1)),
                                     ((5, 9), (1, 0)), ((6, 9), (1, 0)), ((7, 9), (1, 0)), ((8, 9), (0, -1)),
                                     ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((7, 8), (0, 1)), ((7, 9), (-1, 0)),
                                     ((6, 9), (-1, 0)), ((5, 9), (-1, 0)), ((4, 9), (0, -1)), ((4, 8), (-1, 0)),
                                     ((3, 8), (-1, 0)), ((2, 8), (-1, 0)), ((1, 8), (0, 1)), ((1, 9), (0, 1)),
                                     ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)),
                                     ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)),
                                     ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)),
                                     ((1, 22), (0, 1)), ((1, 23), (0, 1)), ((8, 6), (1, 0)), ((7, 5), (0, 1)),
                                     ((7, 6), (0, 1)), ((7, 7), (0, 1)), ((7, 8), (0, 1)), ((7, 9), (-1, 0)),
                                     ((6, 9), (-1, 0)), ((5, 9), (-1, 0)), ((4, 9), (0, -1)), ((4, 8), (-1, 0)),
                                     ((3, 8), (-1, 0)), ((2, 8), (-1, 0)), ((1, 8), (0, 1)), ((1, 9), (0, 1)),
                                     ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)),
                                     ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)),
                                     ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)),
                                     ((1, 22), (0, 1)), ((1, 23), (0, 1)), ((7, 12), (0, -1)), ((7, 11), (0, -1)),
                                     ((7, 10), (0, -1)), ((7, 9), (-1, 0)), ((6, 9), (-1, 0)), ((5, 9), (-1, 0)),
                                     ((4, 9), (0, -1)), ((4, 8), (-1, 0)), ((3, 8), (-1, 0)), ((2, 8), (-1, 0)),
                                     ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)),
                                     ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)),
                                     ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)),
                                     ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((1, 23), (0, 1)),
                                     ((7, 3), (0, 1)), ((7, 4), (0, 1)), ((7, 5), (0, 1)), ((7, 6), (0, 1)),
                                     ((7, 7), (0, 1)), ((7, 8), (0, 1)), ((7, 9), (-1, 0)), ((6, 9), (-1, 0)),
                                     ((5, 9), (-1, 0)), ((4, 9), (0, -1)), ((4, 8), (-1, 0)), ((3, 8), (-1, 0)),
                                     ((2, 8), (-1, 0)), ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)),
                                     ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)),
                                     ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)),
                                     ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)),
                                     ((1, 23), (0, 1)), ((9, 6), (1, 0)), ((10, 6), (1, 0)), ((11, 6), (0, 1)),
                                     ((10, 4), (0, 1)), ((10, 5), (0, 1)), ((10, 6), (-1, 0)), ((9, 6), (-1, 0)),
                                     ((8, 6), (-1, 0)), ((7, 6), (0, 1)), ((7, 7), (0, 1)), ((7, 8), (0, 1)),
                                     ((7, 9), (-1, 0)), ((6, 9), (-1, 0)), ((5, 9), (-1, 0)), ((4, 9), (0, -1)),
                                     ((4, 8), (-1, 0)), ((3, 8), (-1, 0)), ((2, 8), (-1, 0)), ((1, 8), (0, 1)),
                                     ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)),
                                     ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)),
                                     ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)),
                                     ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((1, 23), (0, 1)), ((11, 7), (0, 1)),
                                     ((10, 7), (0, -1)), ((10, 6), (-1, 0)), ((9, 6), (-1, 0)), ((8, 6), (-1, 0)),
                                     ((7, 6), (0, 1)), ((7, 7), (0, 1)), ((7, 8), (0, 1)), ((7, 9), (-1, 0)),
                                     ((6, 9), (-1, 0)), ((5, 9), (-1, 0)), ((4, 9), (0, -1)), ((4, 8), (-1, 0)),
                                     ((3, 8), (-1, 0)), ((2, 8), (-1, 0)), ((1, 8), (0, 1)), ((1, 9), (0, 1)),
                                     ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)),
                                     ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)),
                                     ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)),
                                     ((1, 22), (0, 1)), ((1, 23), (0, 1)), ((11, 8), (-1, 0)), ((10, 8), (0, -1)),
                                     ((10, 7), (0, -1)), ((10, 6), (-1, 0)), ((9, 6), (-1, 0)), ((8, 6), (-1, 0)),
                                     ((7, 6), (0, 1)), ((7, 7), (0, 1)), ((7, 8), (0, 1)), ((7, 9), (-1, 0)),
                                     ((6, 9), (-1, 0)), ((5, 9), (-1, 0)), ((4, 9), (0, -1)), ((4, 8), (-1, 0)),
                                     ((3, 8), (-1, 0)), ((2, 8), (-1, 0)), ((1, 8), (0, 1)), ((1, 9), (0, 1)),
                                     ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)),
                                     ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)),
                                     ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)),
                                     ((1, 22), (0, 1)), ((1, 23), (0, 1)), ((10, 11), (0, -1)), ((10, 10), (0, -1)),
                                     ((10, 9), (0, -1)), ((10, 8), (0, -1)), ((10, 7), (0, -1)), ((10, 6), (-1, 0)),
                                     ((9, 6), (-1, 0)), ((8, 6), (-1, 0)), ((7, 6), (0, 1)), ((7, 7), (0, 1)),
                                     ((7, 8), (0, 1)), ((7, 9), (-1, 0)), ((6, 9), (-1, 0)), ((5, 9), (-1, 0)),
                                     ((4, 9), (0, -1)), ((4, 8), (-1, 0)), ((3, 8), (-1, 0)), ((2, 8), (-1, 0)),
                                     ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)),
                                     ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)),
                                     ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)),
                                     ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((1, 23), (0, 1)),
                                     ((11, 9), (-1, 0)), ((10, 9), (0, -1)), ((10, 8), (0, -1)), ((10, 7), (0, -1)),
                                     ((10, 6), (-1, 0)), ((9, 6), (-1, 0)), ((8, 6), (-1, 0)), ((7, 6), (0, 1)),
                                     ((7, 7), (0, 1)), ((7, 8), (0, 1)), ((7, 9), (-1, 0)), ((6, 9), (-1, 0)),
                                     ((5, 9), (-1, 0)), ((4, 9), (0, -1)), ((4, 8), (-1, 0)), ((3, 8), (-1, 0)),
                                     ((2, 8), (-1, 0)), ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)),
                                     ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)),
                                     ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)),
                                     ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)),
                                     ((1, 23), (0, 1)), ((14, 7), (0, 1)), ((14, 8), (-1, 0)), ((13, 8), (-1, 0)),
                                     ((12, 8), (-1, 0)), ((11, 8), (-1, 0)), ((10, 8), (0, -1)), ((10, 7), (0, -1)),
                                     ((10, 6), (-1, 0)), ((9, 6), (-1, 0)), ((8, 6), (-1, 0)), ((7, 6), (0, 1)),
                                     ((7, 7), (0, 1)), ((7, 8), (0, 1)), ((7, 9), (-1, 0)), ((6, 9), (-1, 0)),
                                     ((5, 9), (-1, 0)), ((4, 9), (0, -1)), ((4, 8), (-1, 0)), ((3, 8), (-1, 0)),
                                     ((2, 8), (-1, 0)), ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)),
                                     ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)),
                                     ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)),
                                     ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)),
                                     ((1, 23), (0, 1)), ((14, 5), (0, 1)), ((14, 6), (0, 1)), ((14, 7), (0, 1)),
                                     ((14, 8), (-1, 0)), ((13, 8), (-1, 0)), ((12, 8), (-1, 0)), ((11, 8), (-1, 0)),
                                     ((10, 8), (0, -1)), ((10, 7), (0, -1)), ((10, 6), (-1, 0)), ((9, 6), (-1, 0)),
                                     ((8, 6), (-1, 0)), ((7, 6), (0, 1)), ((7, 7), (0, 1)), ((7, 8), (0, 1)),
                                     ((7, 9), (-1, 0)), ((6, 9), (-1, 0)), ((5, 9), (-1, 0)), ((4, 9), (0, -1)),
                                     ((4, 8), (-1, 0)), ((3, 8), (-1, 0)), ((2, 8), (-1, 0)), ((1, 8), (0, 1)),
                                     ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)),
                                     ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)),
                                     ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)),
                                     ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((1, 23), (0, 1)), ((14, 3), (0, 1)),
                                     ((14, 4), (0, 1)), ((14, 5), (0, 1)), ((14, 6), (0, 1)), ((14, 7), (0, 1)),
                                     ((14, 8), (-1, 0)), ((13, 8), (-1, 0)), ((12, 8), (-1, 0)), ((11, 8), (-1, 0)),
                                     ((10, 8), (0, -1)), ((10, 7), (0, -1)), ((10, 6), (-1, 0)), ((9, 6), (-1, 0)),
                                     ((8, 6), (-1, 0)), ((7, 6), (0, 1)), ((7, 7), (0, 1)), ((7, 8), (0, 1)),
                                     ((7, 9), (-1, 0)), ((6, 9), (-1, 0)), ((5, 9), (-1, 0)), ((4, 9), (0, -1)),
                                     ((4, 8), (-1, 0)), ((3, 8), (-1, 0)), ((2, 8), (-1, 0)), ((1, 8), (0, 1)),
                                     ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)),
                                     ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)),
                                     ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)),
                                     ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((1, 23), (0, 1)), ((15, 3), (-1, 0)),
                                     ((14, 3), (0, 1)), ((14, 4), (0, 1)), ((14, 5), (0, 1)), ((14, 6), (0, 1)),
                                     ((14, 7), (0, 1)), ((14, 8), (-1, 0)), ((13, 8), (-1, 0)), ((12, 8), (-1, 0)),
                                     ((11, 8), (-1, 0)), ((10, 8), (0, -1)), ((10, 7), (0, -1)), ((10, 6), (-1, 0)),
                                     ((9, 6), (-1, 0)), ((8, 6), (-1, 0)), ((7, 6), (0, 1)), ((7, 7), (0, 1)),
                                     ((7, 8), (0, 1)), ((7, 9), (-1, 0)), ((6, 9), (-1, 0)), ((5, 9), (-1, 0)),
                                     ((4, 9), (0, -1)), ((4, 8), (-1, 0)), ((3, 8), (-1, 0)), ((2, 8), (-1, 0)),
                                     ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)),
                                     ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)),
                                     ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)),
                                     ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((1, 23), (0, 1)),
                                     ((12, 6), (0, 1)), ((12, 7), (0, 1)), ((12, 8), (1, 0)), ((13, 8), (1, 0)),
                                     ((14, 8), (1, 0)), ((15, 8), (0, -1)), ((15, 7), (0, -1)), ((15, 6), (0, -1)),
                                     ((15, 5), (0, -1)), ((15, 4), (0, -1)), ((15, 3), (-1, 0)), ((14, 3), (0, 1)),
                                     ((14, 4), (0, 1)), ((14, 5), (0, 1)), ((14, 6), (0, 1)), ((14, 7), (0, 1)),
                                     ((14, 8), (-1, 0)), ((13, 8), (-1, 0)), ((12, 8), (-1, 0)), ((11, 8), (-1, 0)),
                                     ((10, 8), (0, -1)), ((10, 7), (0, -1)), ((10, 6), (-1, 0)), ((9, 6), (-1, 0)),
                                     ((8, 6), (-1, 0)), ((7, 6), (0, 1)), ((7, 7), (0, 1)), ((7, 8), (0, 1)),
                                     ((7, 9), (-1, 0)), ((6, 9), (-1, 0)), ((5, 9), (-1, 0)), ((4, 9), (0, -1)),
                                     ((4, 8), (-1, 0)), ((3, 8), (-1, 0)), ((2, 8), (-1, 0)), ((1, 8), (0, 1)),
                                     ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)),
                                     ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)),
                                     ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)),
                                     ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((1, 23), (0, 1)), ((5, 6), (0, 1)),
                                     ((5, 7), (0, 1)), ((5, 8), (0, 1)), ((5, 9), (1, 0)), ((6, 9), (1, 0)),
                                     ((7, 9), (1, 0)), ((8, 9), (0, -1)), ((8, 8), (0, -1)), ((8, 7), (0, -1)),
                                     ((8, 6), (1, 0)), ((9, 6), (1, 0)), ((10, 6), (1, 0)), ((11, 6), (-1, 0)),
                                     ((10, 6), (-1, 0)), ((9, 6), (-1, 0)), ((8, 6), (-1, 0)), ((7, 6), (0, 1)),
                                     ((7, 7), (0, 1)), ((7, 8), (0, 1)), ((7, 9), (-1, 0)), ((6, 9), (-1, 0)),
                                     ((5, 9), (-1, 0)), ((4, 9), (0, -1)), ((4, 8), (-1, 0)), ((3, 8), (-1, 0)),
                                     ((2, 8), (-1, 0)), ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)),
                                     ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)),
                                     ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)),
                                     ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)),
                                     ((1, 23), (0, 1)), ((5, 12), (0, -1)), ((5, 11), (0, -1)), ((5, 10), (0, -1)),
                                     ((5, 9), (1, 0)), ((6, 9), (1, 0)), ((7, 9), (1, 0)), ((8, 9), (0, -1)),
                                     ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (1, 0)), ((9, 6), (1, 0)),
                                     ((10, 6), (1, 0)), ((11, 6), (-1, 0)), ((10, 6), (-1, 0)), ((9, 6), (-1, 0)),
                                     ((8, 6), (-1, 0)), ((7, 6), (0, 1)), ((7, 7), (0, 1)), ((7, 8), (0, 1)),
                                     ((7, 9), (-1, 0)), ((6, 9), (-1, 0)), ((5, 9), (-1, 0)), ((4, 9), (0, -1)),
                                     ((4, 8), (-1, 0)), ((3, 8), (-1, 0)), ((2, 8), (-1, 0)), ((1, 8), (0, 1)),
                                     ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)),
                                     ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)),
                                     ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)),
                                     ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((1, 23), (0, 1)), ((5, 4), (0, 1)),
                                     ((5, 5), (0, 1)), ((5, 6), (0, 1)), ((5, 7), (0, 1)), ((5, 8), (0, 1)),
                                     ((5, 9), (1, 0)), ((6, 9), (1, 0)), ((7, 9), (1, 0)), ((8, 9), (0, -1)),
                                     ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (1, 0)), ((9, 6), (1, 0)),
                                     ((10, 6), (1, 0)), ((11, 6), (-1, 0)), ((10, 6), (-1, 0)), ((9, 6), (-1, 0)),
                                     ((8, 6), (-1, 0)), ((7, 6), (0, 1)), ((7, 7), (0, 1)), ((7, 8), (0, 1)),
                                     ((7, 9), (-1, 0)), ((6, 9), (-1, 0)), ((5, 9), (-1, 0)), ((4, 9), (0, -1)),
                                     ((4, 8), (-1, 0)), ((3, 8), (-1, 0)), ((2, 8), (-1, 0)), ((1, 8), (0, 1)),
                                     ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)),
                                     ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)),
                                     ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)),
                                     ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((1, 23), (0, 1)), ((12, 4), (0, 1)),
                                     ((12, 5), (0, 1)), ((12, 6), (0, 1)), ((12, 7), (0, 1)), ((12, 8), (1, 0)),
                                     ((13, 8), (1, 0)), ((14, 8), (1, 0)), ((15, 8), (0, -1)), ((15, 7), (0, -1)),
                                     ((15, 6), (0, -1)), ((15, 5), (0, -1)), ((15, 4), (0, -1)), ((15, 3), (-1, 0)),
                                     ((14, 3), (0, 1)), ((14, 4), (0, 1)), ((14, 5), (0, 1)), ((14, 6), (0, 1)),
                                     ((14, 7), (0, 1)), ((14, 8), (-1, 0)), ((13, 8), (-1, 0)), ((12, 8), (-1, 0)),
                                     ((11, 8), (-1, 0)), ((10, 8), (0, -1)), ((10, 7), (0, -1)), ((10, 6), (-1, 0)),
                                     ((9, 6), (-1, 0)), ((8, 6), (-1, 0)), ((7, 6), (0, 1)), ((7, 7), (0, 1)),
                                     ((7, 8), (0, 1)), ((7, 9), (-1, 0)), ((6, 9), (-1, 0)), ((5, 9), (-1, 0)),
                                     ((4, 9), (0, -1)), ((4, 8), (-1, 0)), ((3, 8), (-1, 0)), ((2, 8), (-1, 0)),
                                     ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)),
                                     ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)),
                                     ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)),
                                     ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((1, 23), (0, 1))], '''\
       ------------------------
       |...................^..|
       |..-------------------.|
     ----.|    -----        |.|
     |..|0--  --...|        |.|
     |.....|--|.0..|        |.|
     |.00..|..|..0.|        |.|
     --..00|...00.--        |.|
      |0..0...|0..|   ------|.|
      |.00.|..|..0| --|.....|.|
      |.0.0---|.0.| |.+.....|.|
      |.......|..-- |-|.....|.|
      ----.0..|.--  |.+.....+.|
         ---.--.|   |-|.....|--
          |.0...|   |.+.....|  
          |>.|..|   --|.....|  
          -------     -------  ''': [((14, 8), (0, 1)), ((14, 9), (0, 1)), ((14, 10), (0, 1)), ((14, 11), (-1, 0)),
                                     ((13, 11), (-1, 0)), ((12, 11), (-1, 0)), ((11, 11), (-1, 0)), ((10, 12), (-1, 0)),
                                     ((9, 13), (-1, 0)), ((8, 13), (-1, 0)), ((7, 12), (-1, 0)), ((7, 11), (0, -1)),
                                     ((7, 10), (0, -1)), ((7, 9), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (0, -1)),
                                     ((7, 5), (-1, 0)), ((6, 3), (-1, 0)), ((5, 3), (1, 0)), ((4, 5), (-1, 0)),
                                     ((3, 5), (-1, 0)), ((2, 5), (-1, 0)), ((1, 5), (0, 1)), ((1, 6), (0, 1)),
                                     ((1, 7), (0, 1)), ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)),
                                     ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)),
                                     ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)),
                                     ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)),
                                     ((7, 6), (1, 0)), ((6, 5), (-1, 0)), ((5, 5), (-1, 0)), ((4, 5), (-1, 0)),
                                     ((3, 5), (-1, 0)), ((2, 5), (-1, 0)), ((1, 5), (0, 1)), ((1, 6), (0, 1)),
                                     ((1, 7), (0, 1)), ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)),
                                     ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)),
                                     ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)),
                                     ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)),
                                     ((6, 3), (-1, 0)), ((5, 3), (0, 1)), ((5, 4), (0, 1)), ((5, 5), (-1, 0)),
                                     ((4, 5), (-1, 0)), ((3, 5), (-1, 0)), ((2, 5), (-1, 0)), ((1, 5), (0, 1)),
                                     ((1, 6), (0, 1)), ((1, 7), (0, 1)), ((1, 8), (0, 1)), ((1, 9), (0, 1)),
                                     ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)),
                                     ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)),
                                     ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)),
                                     ((1, 22), (0, 1)), ((6, 4), (0, 1)), ((6, 5), (-1, 0)), ((5, 5), (-1, 0)),
                                     ((4, 5), (-1, 0)), ((3, 5), (-1, 0)), ((2, 5), (-1, 0)), ((1, 5), (0, 1)),
                                     ((1, 6), (0, 1)), ((1, 7), (0, 1)), ((1, 8), (0, 1)), ((1, 9), (0, 1)),
                                     ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)),
                                     ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)),
                                     ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)),
                                     ((1, 22), (0, 1)), ((9, 5), (1, 0)), ((8, 6), (-1, 0)), ((7, 8), (1, 0)),
                                     ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (-1, 0)),
                                     ((7, 5), (-1, 0)), ((6, 5), (-1, 0)), ((5, 5), (-1, 0)), ((4, 5), (-1, 0)),
                                     ((3, 5), (-1, 0)), ((2, 5), (-1, 0)), ((1, 5), (0, 1)), ((1, 6), (0, 1)),
                                     ((1, 7), (0, 1)), ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)),
                                     ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)),
                                     ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)),
                                     ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)),
                                     ((10, 5), (-1, 0)), ((9, 5), (-1, 0)), ((8, 5), (-1, 0)), ((7, 5), (-1, 0)),
                                     ((6, 5), (-1, 0)), ((5, 5), (-1, 0)), ((4, 5), (-1, 0)), ((3, 5), (-1, 0)),
                                     ((2, 5), (-1, 0)), ((1, 5), (0, 1)), ((1, 6), (0, 1)), ((1, 7), (0, 1)),
                                     ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)),
                                     ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)),
                                     ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)),
                                     ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((10, 4), (0, 1)),
                                     ((10, 5), (-1, 0)), ((9, 5), (-1, 0)), ((8, 5), (-1, 0)), ((7, 5), (-1, 0)),
                                     ((6, 5), (-1, 0)), ((5, 5), (-1, 0)), ((4, 5), (-1, 0)), ((3, 5), (-1, 0)),
                                     ((2, 5), (-1, 0)), ((1, 5), (0, 1)), ((1, 6), (0, 1)), ((1, 7), (0, 1)),
                                     ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)),
                                     ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)),
                                     ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)),
                                     ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((9, 4), (0, 1)),
                                     ((9, 5), (-1, 0)), ((8, 5), (-1, 0)), ((7, 5), (-1, 0)), ((6, 5), (-1, 0)),
                                     ((5, 5), (-1, 0)), ((4, 5), (-1, 0)), ((3, 5), (-1, 0)), ((2, 5), (-1, 0)),
                                     ((1, 5), (0, 1)), ((1, 6), (0, 1)), ((1, 7), (0, 1)), ((1, 8), (0, 1)),
                                     ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)),
                                     ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)),
                                     ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)),
                                     ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((8, 4), (1, 0)), ((9, 4), (0, 1)),
                                     ((9, 5), (-1, 0)), ((8, 5), (-1, 0)), ((7, 5), (-1, 0)), ((6, 5), (-1, 0)),
                                     ((5, 5), (-1, 0)), ((4, 5), (-1, 0)), ((3, 5), (-1, 0)), ((2, 5), (-1, 0)),
                                     ((1, 5), (0, 1)), ((1, 6), (0, 1)), ((1, 7), (0, 1)), ((1, 8), (0, 1)),
                                     ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)),
                                     ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)),
                                     ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)),
                                     ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((8, 3), (-1, 0)), ((7, 3), (-1, 0)),
                                     ((6, 3), (-1, 0)), ((5, 3), (0, 1)), ((5, 4), (0, 1)), ((5, 5), (-1, 0)),
                                     ((4, 5), (-1, 0)), ((3, 5), (-1, 0)), ((2, 5), (-1, 0)), ((1, 5), (0, 1)),
                                     ((1, 6), (0, 1)), ((1, 7), (0, 1)), ((1, 8), (0, 1)), ((1, 9), (0, 1)),
                                     ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)),
                                     ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)),
                                     ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)),
                                     ((1, 22), (0, 1)), ((10, 6), (-1, 0)), ((9, 6), (-1, 0)), ((8, 6), (0, -1)),
                                     ((8, 5), (-1, 0)), ((7, 5), (-1, 0)), ((6, 5), (-1, 0)), ((5, 5), (-1, 0)),
                                     ((4, 5), (-1, 0)), ((3, 5), (-1, 0)), ((2, 5), (-1, 0)), ((1, 5), (0, 1)),
                                     ((1, 6), (0, 1)), ((1, 7), (0, 1)), ((1, 8), (0, 1)), ((1, 9), (0, 1)),
                                     ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)),
                                     ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)),
                                     ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)),
                                     ((1, 22), (0, 1)), ((7, 6), (1, 0)), ((8, 6), (0, -1)), ((8, 5), (-1, 0)),
                                     ((7, 5), (-1, 0)), ((6, 5), (-1, 0)), ((5, 5), (-1, 0)), ((4, 5), (-1, 0)),
                                     ((3, 5), (-1, 0)), ((2, 5), (-1, 0)), ((1, 5), (0, 1)), ((1, 6), (0, 1)),
                                     ((1, 7), (0, 1)), ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)),
                                     ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)),
                                     ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)),
                                     ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)),
                                     ((12, 7), (0, 1)), ((12, 8), (-1, 0)), ((11, 8), (0, -1)), ((11, 7), (0, -1)),
                                     ((11, 6), (-1, 0)), ((10, 6), (-1, 0)), ((9, 6), (-1, 0)), ((8, 6), (0, -1)),
                                     ((8, 5), (-1, 0)), ((7, 5), (-1, 0)), ((6, 5), (-1, 0)), ((5, 5), (-1, 0)),
                                     ((4, 5), (-1, 0)), ((3, 5), (-1, 0)), ((2, 5), (-1, 0)), ((1, 5), (0, 1)),
                                     ((1, 6), (0, 1)), ((1, 7), (0, 1)), ((1, 8), (0, 1)), ((1, 9), (0, 1)),
                                     ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)),
                                     ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)),
                                     ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)),
                                     ((1, 22), (0, 1)), ((5, 12), (0, 1)), ((6, 12), (1, 0)), ((6, 13), (0, -1)),
                                     ((6, 12), (0, -1)), ((7, 13), (1, 0)), ((7, 12), (0, -1)), ((7, 11), (0, -1)),
                                     ((7, 10), (0, -1)), ((7, 9), (0, -1)), ((7, 8), (1, 0)), ((8, 8), (0, -1)),
                                     ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (-1, 0)), ((7, 5), (-1, 0)),
                                     ((6, 5), (-1, 0)), ((5, 5), (-1, 0)), ((4, 5), (-1, 0)), ((3, 5), (-1, 0)),
                                     ((2, 5), (-1, 0)), ((1, 5), (0, 1)), ((1, 6), (0, 1)), ((1, 7), (0, 1)),
                                     ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)),
                                     ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)),
                                     ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)),
                                     ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((6, 11), (1, 0)),
                                     ((7, 11), (0, -1)), ((7, 10), (0, -1)), ((7, 9), (0, -1)), ((7, 8), (1, 0)),
                                     ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (-1, 0)),
                                     ((7, 5), (-1, 0)), ((6, 5), (-1, 0)), ((5, 5), (-1, 0)), ((4, 5), (-1, 0)),
                                     ((3, 5), (-1, 0)), ((2, 5), (-1, 0)), ((1, 5), (0, 1)), ((1, 6), (0, 1)),
                                     ((1, 7), (0, 1)), ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)),
                                     ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)),
                                     ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)),
                                     ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)),
                                     ((5, 13), (0, -1)), ((5, 12), (1, 0)), ((6, 12), (1, 0)), ((7, 12), (0, -1)),
                                     ((7, 11), (0, -1)), ((7, 10), (0, -1)), ((7, 9), (0, -1)), ((7, 8), (1, 0)),
                                     ((8, 8), (0, -1)), ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (-1, 0)),
                                     ((7, 5), (-1, 0)), ((6, 5), (-1, 0)), ((5, 5), (-1, 0)), ((4, 5), (-1, 0)),
                                     ((3, 5), (-1, 0)), ((2, 5), (-1, 0)), ((1, 5), (0, 1)), ((1, 6), (0, 1)),
                                     ((1, 7), (0, 1)), ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)),
                                     ((1, 11), (0, 1)), ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)),
                                     ((1, 15), (0, 1)), ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)),
                                     ((1, 19), (0, 1)), ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)),
                                     ((8, 13), (-1, 0)), ((7, 13), (-1, 0)), ((6, 13), (-1, 0)), ((5, 13), (0, -1)),
                                     ((5, 12), (1, 0)), ((6, 12), (1, 0)), ((7, 12), (0, -1)), ((7, 11), (0, -1)),
                                     ((7, 10), (0, -1)), ((7, 9), (0, -1)), ((7, 8), (1, 0)), ((8, 8), (0, -1)),
                                     ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (-1, 0)), ((7, 5), (-1, 0)),
                                     ((6, 5), (-1, 0)), ((5, 5), (-1, 0)), ((4, 5), (-1, 0)), ((3, 5), (-1, 0)),
                                     ((2, 5), (-1, 0)), ((1, 5), (0, 1)), ((1, 6), (0, 1)), ((1, 7), (0, 1)),
                                     ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)),
                                     ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)),
                                     ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)),
                                     ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((9, 12), (-1, 0)),
                                     ((8, 12), (-1, 0)), ((7, 12), (0, -1)), ((7, 11), (0, -1)), ((7, 10), (0, -1)),
                                     ((7, 9), (0, -1)), ((7, 8), (1, 0)), ((8, 8), (0, -1)), ((8, 7), (0, -1)),
                                     ((8, 6), (0, -1)), ((8, 5), (-1, 0)), ((7, 5), (-1, 0)), ((6, 5), (-1, 0)),
                                     ((5, 5), (-1, 0)), ((4, 5), (-1, 0)), ((3, 5), (-1, 0)), ((2, 5), (-1, 0)),
                                     ((1, 5), (0, 1)), ((1, 6), (0, 1)), ((1, 7), (0, 1)), ((1, 8), (0, 1)),
                                     ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)),
                                     ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)),
                                     ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)),
                                     ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((8, 11), (-1, 0)), ((7, 11), (0, -1)),
                                     ((7, 10), (0, -1)), ((7, 9), (0, -1)), ((7, 8), (1, 0)), ((8, 8), (0, -1)),
                                     ((8, 7), (0, -1)), ((8, 6), (0, -1)), ((8, 5), (-1, 0)), ((7, 5), (-1, 0)),
                                     ((6, 5), (-1, 0)), ((5, 5), (-1, 0)), ((4, 5), (-1, 0)), ((3, 5), (-1, 0)),
                                     ((2, 5), (-1, 0)), ((1, 5), (0, 1)), ((1, 6), (0, 1)), ((1, 7), (0, 1)),
                                     ((1, 8), (0, 1)), ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)),
                                     ((1, 12), (0, 1)), ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)),
                                     ((1, 16), (0, 1)), ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)),
                                     ((1, 20), (0, 1)), ((1, 21), (0, 1)), ((1, 22), (0, 1)), ((10, 11), (-1, 0)),
                                     ((9, 11), (-1, 0)), ((8, 11), (-1, 0)), ((7, 11), (0, -1)), ((7, 10), (0, -1)),
                                     ((7, 9), (0, -1)), ((7, 8), (1, 0)), ((8, 8), (0, -1)), ((8, 7), (0, -1)),
                                     ((8, 6), (0, -1)), ((8, 5), (-1, 0)), ((7, 5), (-1, 0)), ((6, 5), (-1, 0)),
                                     ((5, 5), (-1, 0)), ((4, 5), (-1, 0)), ((3, 5), (-1, 0)), ((2, 5), (-1, 0)),
                                     ((1, 5), (0, 1)), ((1, 6), (0, 1)), ((1, 7), (0, 1)), ((1, 8), (0, 1)),
                                     ((1, 9), (0, 1)), ((1, 10), (0, 1)), ((1, 11), (0, 1)), ((1, 12), (0, 1)),
                                     ((1, 13), (0, 1)), ((1, 14), (0, 1)), ((1, 15), (0, 1)), ((1, 16), (0, 1)),
                                     ((1, 17), (0, 1)), ((1, 18), (0, 1)), ((1, 19), (0, 1)), ((1, 20), (0, 1)),
                                     ((1, 21), (0, 1)), ((1, 22), (0, 1))], }
