# Installation
Our code has a C++ backend, with python interface, that has to be compiled prior to launching the experiments. It was tested on linux and macos, with the latest version of gcc.
 - in a terminal, in the `src_mma_forked_with_gudhi` folder,
```
pip install .
```

 It requires a few dependencies to be installed, which can be obtained via the conda environment :
```sh
conda create -n python311
conda activate python311
conda install python=3.11 cxx-compiler boost tbb tbb-devel numpy matplotlib gudhi scikit-learn cython sympy tqdm cycler typing shapely -c conda-forge
pip install filtration-domination # optional. If using Rips Filtrations, this allows to use edge collapses.
```
This will install the python libraries that we used to run all of our code.
 - then, our code can be used in python with : 
```sh
import mma
```
 - The non-synthetic datasets can be retrieved from the internet:
	- The immunohistochemistry datasets can be retrieved at https://github.com/MultiparameterTDAHistology/SpatialPatterningOfImmuneCells/
	- the UCR time series datasets can be retrieved from: https://www.cs.ucr.edu/~eamonn/time_series_data_2018/

/!\ The scripts expects the datasets to be stored at `~/Datasets/`.
For instance `~/Datasets/UCR`, or `~/Datasets/1.5mmRegions/`

/!\    Note that if you want to compute the multiparameter persistence image of Carrière & Blumberg 
    (https://papers.nips.cc/paper/2020/hash/fdff71fcab656abfbefaabecab1a7f6d-Abstract.html),
    you will need to compile the dionysus implementation of vineyards. 
	
For this, follow 
the procedure detailed in https://github.com/MathieuCarriere/multipers
Our code can be used without it, by commenting 
`from dionysus_vineyards import ls_vineyards as lsvine` in line 18 in 
`src_mma_forked_with_gudhi/multipers.py` and `from multipers import *` in all Python scripts that
contain this line.


# Experiments
## Convergence rates
For convergence rates, ie, in the convergence rate folder,
 - You can compute the modules with the `cv_immuno.py` / `cv_synthetic.py` / `cv_synthetic2.py` scripts
	they will be stored in the same folder as the dataset

		python cv_immuno.py 1 30 10
			where	1: dataset number
					30: triangulation grid size (faster with smaller numbers)
					10: number of iterations
		python cv_synthetic.py 10 1000 100
			where 	10: minimum number of points in the datasets
					1000: maximum number of points 
					100: number of iterations
 - You can then compute the images using the `get_imgs.py` / `get_immuno_imgs.py` scripts.
	the representation parameters have to be tuned inside the scripts
## Classifications

For classification, ie in the `classification` folder,
 - `experiments.py` will allow you to compute modules, and cross-validate (parameters inside have to be tuned) the image parameters. You may want to reduce the number of parameters to cross-validate to test the script (line 377).

		python experiments.py Coffee 50 1 10
			where:	Coffee: the name of the datasets
					50: the image resolutions
					1 : force recompute the modules
					10 : number of cores to use
 - `landscape_experiments.py` : the same, but with our multiparameter persistence landscape implementation

		python landscape_experiments.py Coffee 50 1 10
			where	Coffee: the dataset name
					50: image resolution
					1 : force recompute modules
					10 : number of cores to use
 - `multipers_experiments.py` : the same, but with the MPI image from https://github.com/MathieuCarriere/multipers/blob/main/multipers.py

 - in the immuno folder:
   - `compute.py` : will compute the immuno classification with cross-validation parameters to tune inside the file. 
   - Use, e.g.,  to launch our pipeline with a 5-fold, the rips complex, and a random forest, one can use :
```
compute.py --pipeline image --k 5 --classifier rf --complex rips
```
More details are available with `compute.py --help`.
