import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import dataframe_image as dfi

# Data: counts for all raters
data = {
    'Direct Prompting': [13, 7, 4, 14, 1, 7, 9, 8, 9, 8],
    'Concept Composition': [5, 9, 15, 15, 4, 5, 7, 3, 12, 6],
    'Concept Algebra': [29, 20, 23, 14, 31, 25, 25, 32, 19, 16],
    'All Bad': [3, 14, 8, 7, 14, 10, 6, 6, 10, 20]
}

# Convert to DataFrame
df = pd.DataFrame(data)
df['Total'] = df.sum(axis=1)
print(df)
N = df['Total'].sum()

average_proportions = df.drop(columns="Total").div(df["Total"], axis=0).mean()
sd = np.sqrt(average_proportions * (1 - average_proportions) / N)
table = pd.concat([average_proportions, sd], axis=1)
table.columns = ['Average Proportion', 'Standard Deviation']
table = table.T.round(4)
print(table)
# dfi.export(table, 'final_table.png')
