#ifndef VDA_ALGORITHM_H_
#define VDA_ALGORITHM_H_

#include<iostream>
#include<vector>
#include<cmath>

#include "def_the_type.h"
#include "data.h"
using namespace std;
class VDA_algorithm {
    private:

        the_Matrix XXT;
        vector<T> XY;

        // averaging data
        the_Matrix lower_averaging_Z;
        vector<T> lower_averaging_y;
        // count the observations within each group
        vector<int> lower_averaging_counter;

        the_Matrix upper_averaging_Z;
        vector<T> upper_averaging_y;
        vector<int> upper_averaging_counter;

        void select_and_average();
        // compute the matrices need for LSE
        void compute();
        // solve the LSE
        vector<T> solve();


    public:
        the_Data *data;
        VDA_algorithm(the_Data *input_data);
        ~VDA_algorithm();
        int N, n, p, r;
        vector<T> Execute();
};

#endif
