#ifndef SRHT_ALGORITHM_H_
#define SRHT_ALGORITHM_H_

#include<iostream>
#include<vector>
#include<cmath>

#include "def_the_type.h"
#include "data.h"
using namespace std;
// subsampled randomized Hadamard transform algorithm
class SRHT_algorithm {
    private:

        // initally is an all one vector
        vector<T> constant_term;


        //vector<vector<T>> XXT;
        the_Matrix XXT;
        vector<T> XY;

        //vector<int> permute_indices;
        void sign_flipping();
        void transform(int left, int right);
        // compute the matrices need for LSE
        void compute();
        // solve the LSE
        vector<T> solve();

    public:
        the_Data *data;
        SRHT_algorithm(the_Data *input_data, int n);
        int N, p, n;
        vector<T> Execute();
        
        vector<bool> position_flag;
};

#endif
