#include <algorithm>
#include <chrono>
#include <cmath>
#include "NEW_algorithm.h"
#include "floyd_rivest_select.h"
using namespace std;

// constructor
NEW_algorithm::NEW_algorithm(the_Data *input_data){
    this -> data = input_data;

    this -> N  = input_data -> N;
    this -> p  = input_data -> p;
    this -> n  = this -> N;
    this -> r = n / 2 / this -> p;

    thresholds_upper.resize(this -> p);
    thresholds_lower.resize(this -> p);
    if_selected.resize(this -> N);

    XXT.init(p+1, p+1);

    XY.resize(p+1);
    for(int i=0; i < p+1; ++i){
            XY[i] = 0;
    }

    for(int i =0; i < N; ++i){
        if_selected[i] = false;
    }

    lower_averaging_Z.init(p, p);

    lower_averaging_y.resize(p);
    for(int i=0; i < p; ++i){
        lower_averaging_y[i] = 0;
    }
    lower_averaging_counter.resize(p);
    for(int i=0; i < p; ++i){
        lower_averaging_counter[i] = 0;
    }

    upper_averaging_Z.init(p,p);

    upper_averaging_y.resize(p);
    for(int i=0; i < p; ++i){
        upper_averaging_y[i] = 0;
    }
    upper_averaging_counter.resize(p);
    for(int i=0; i < p; ++i){
        upper_averaging_counter[i] = 0;
    }
}

NEW_algorithm::~NEW_algorithm(){
}

vector<T> NEW_algorithm::Execute(){
    select_and_average();
    compute();
    vector<T> estimated_beta;
    estimated_beta = solve();
    return estimated_beta;
}

void NEW_algorithm::select_and_average(){

    vector<T> tmp_vector(N);
    for (int j = 0; j < p; ++j ){
        // do select
        int the_size = 0;
        for (int i=0; i < N; ++i){
            if(if_selected[i]){
                continue;
            }
            tmp_vector[the_size] = data -> Z(i, j);
            ++the_size;
        }

        miniselect::floyd_rivest_select(tmp_vector.begin(), tmp_vector.begin() + the_size - r, tmp_vector.begin() + the_size);
        thresholds_upper[j] = *(tmp_vector.begin() + the_size - r);
        miniselect::floyd_rivest_select(tmp_vector.begin(), tmp_vector.begin() + r - 1, tmp_vector.begin() + the_size - r );
        thresholds_lower[j] = *(tmp_vector.begin() + r - 1);
        T* posit_row_contiguous = &((data -> Z).matrix[0]);
        for (int i=0; i < N; ++i){
            if(if_selected[i]){
                posit_row_contiguous += p;
                continue;
            }
            if( *(posit_row_contiguous + j) >= thresholds_upper[j]){
                if_selected[i] = true;
                ++upper_averaging_counter[j];
                upper_averaging_y[j] += data->y[i];
                for(int k = 0; k< p; ++k){
                    upper_averaging_Z(j, k) += *posit_row_contiguous;
                    ++posit_row_contiguous;
                }
            }else if( *(posit_row_contiguous + j) <= thresholds_lower[j]){
                if_selected[i] = true;
                ++lower_averaging_counter[j];
                lower_averaging_y[j] += data->y[i];
                for(int k = 0; k< p;  ++k){
                    lower_averaging_Z(j, k) += *posit_row_contiguous;
                    ++posit_row_contiguous;
                }
            }else{
                posit_row_contiguous += p;
            }

        }
    }
}

void NEW_algorithm::compute(){
    // add averaged data to XXT and XY
    vector<T> tmp_lower_divider(p);
    vector<T> tmp_upper_divider(p);
    for(int i = 0; i < p; ++i){
        tmp_lower_divider[i] = sqrt(double(lower_averaging_counter[i]));
        if(lower_averaging_counter[i] == 0){
            cout << "No averaging data ???" << endl;
            continue;
        }
        lower_averaging_y[i] /= tmp_lower_divider[i];
        for(int j = 0; j < p; ++j){
            lower_averaging_Z(i, j) /= tmp_lower_divider[i];
        }
    }
    for(int i = 0; i < p; ++i){
        tmp_upper_divider[i] = sqrt(double(upper_averaging_counter[i]));
        if(upper_averaging_counter[i] == 0){
            cout << "No averaging data ???" << endl;
            continue;
        }
        upper_averaging_y[i] /= tmp_upper_divider[i];
        for(int j = 0; j < p; ++j){
            upper_averaging_Z(i, j) /= tmp_upper_divider[i];
        }
    }

    for(int counter = 0; counter < p; ++counter){
        XXT(0, 0) += tmp_lower_divider[counter] * tmp_lower_divider[counter] + tmp_upper_divider[counter] * tmp_upper_divider[counter];
        XY[0] += tmp_lower_divider[counter] * lower_averaging_y[counter] + tmp_upper_divider[counter] * upper_averaging_y[counter];
        for(int i = 1; i< p+1; ++i ){
            XXT(i, 0) += tmp_lower_divider[counter] * lower_averaging_Z(counter, i-1) + tmp_upper_divider[counter] * upper_averaging_Z(counter, i-1);
            XY[i] += lower_averaging_Z(counter, i-1) * lower_averaging_y[counter] + upper_averaging_Z(counter, i-1) * upper_averaging_y[counter];
            for(int j = 1; j<= i; ++j){
                XXT(i, j) += lower_averaging_Z(counter, i-1) * lower_averaging_Z(counter, j-1) + upper_averaging_Z(counter, i-1) * upper_averaging_Z(counter, j-1);
            }
        }
    }
}

// Gaussian elimination
vector<T> NEW_algorithm::solve(){

    vector<T> estimated_beta(p+1);

    for(int i = 0; i< p+1; ++i){
        for(int j =i; j< p+1; ++j){
            XXT(i, j) = XXT(j, i);
        }
    }

    for(int counter = 0; counter < p; ++counter){
        for(int i = counter + 1; i < p+1; ++i){
            T the_ratio = XXT(counter, i) / XXT(counter, counter);
            for(int j = counter; j < p+1; ++j){
                XXT(j, i) -= the_ratio * XXT(j, counter);
            }
            XY[i] -= the_ratio * XY[counter];
        }
    }

    for(int i = p; i>=0; --i){
        estimated_beta[i] =  XY[i];
        for(int j = i+1; j<=p; ++j){
            estimated_beta[i] -= XXT(j, i) * estimated_beta[j];
        }
        estimated_beta[i] /= XXT(i, i);
    }
    return estimated_beta;
}
