#!/usr/bin/env python3
# -*- coding:utf-8 -*-
###
# File: types.py
# Created Date: Thursday, February 13th 2020, 4:39:01 pm
# Author: Chirag Raman
#
# Copyright (c) 2020 Chirag Raman
###


from enum import Enum, auto
from typing import Any, NamedTuple

from torch import Tensor


class DataSplit(NamedTuple):

    """ Represents the context and target split of data

    Attributes:
        context -- The context points to condition on
        target  -- The target points to make predictions for

    """
    context: Any
    target: Any


class Seq2SeqSamples(NamedTuple):

    """ Represents a seq2seq data sample

    Attributes:
        key             --  An identifier for the group to which the sample belongs
        observed_start  --  The frame at which the observed sequence starts
        observed        --  The observed sequence features
        future_len      --  The number of time steps to predict in the future
        offset          --  The time offset between the end of the observed and
                            sequence and start of the future sequence
        future          --  The predicted sequence features

    """
    key: Any
    observed_start: int
    observed: Tensor
    future_len: int
    offset: int = 1
    future: Tensor = None


class BucketType(Enum):

    """ Dataset attribute to choose for batch bucketing """

    GROUP = auto()
    SEQ = auto()