module MixFlow

using LinearAlgebra, Distributions, Random, StatsBase, ProgressMeter
using Base.Threads: @threads

abstract type mixflow end
# abstract type flow_param{T} end
# referece distribution is set to be mean-field Gaussian distirbution---N(μ, D^2)
struct HF_params{T}
    leapfrog_stepsize::AbstractVector{T}
    μ::AbstractVector{T} # Gaussian mean
    D::AbstractVector{T} # Diagonal Gaussian std 
end
function HF_params(
    leapfrog_stepsize::T, μ::AbstractVector{T}, D::AbstractVector{T}
) where {T}
    return HF_params(leapfrog_stepsize * one.(μ), μ, D)
end

include("ham.jl")
include("error.jl")
include("shadowing.jl")
end