#!/bin/bash

# Declare hyperparameter arrays
betas=(3.0e-3)
deltas=(0)
seeds=(0 1 2022)

# Function to run a single experiment
run_experiment() {
    local beta=$1
    local delta=$2
    local seed=$3
    python scripts/train_stationary_IFactor_mine.py --beta "$beta" --delta "$delta" --seed "$seed"
}

# Loop through each combination of beta and delta values
num_parallel=0
for beta in "${betas[@]}"; do
    for delta in "${deltas[@]}"; do
        for seed in "${seeds[@]}"; do
            run_experiment "$beta" "$delta" "$seed" &

            # Increment the parallel counter
            num_parallel=$((num_parallel + 1))

            # If two experiments are running, wait for them to finish
            if [ "$num_parallel" -eq 2 ]; then
                wait
                num_parallel=0
            fi
        done
    done
done

# Wait for any remaining background jobs to finish
wait