# default pytorch version
PYTHON=python3.8
PYTORCH_VERSION=1.13.0
PYTORCH_GEOMETRIC_VERSION=2.1.0.post1

# set CUDA variable (defaults to cpu if no argument is provided to the script)
CUDA_VERSION=${1:-cpu}

# create virtual environment and activate it
$PYTHON -m pip install --user virtualenv
$PYTHON -m venv ~/.venv/neurips
source ~/.venv/neurips/bin/activate

pip install build wheel pytest black

# install pytorch
if [[ "$CUDA_VERSION" == "cpu" ]]; then
  pip3 install torch==${PYTORCH_VERSION} torchvision torchaudio --extra-index-url https://download.pytorch.org/whl/cpu
elif [[ "$CUDA_VERSION" == 'cu116' ]]; then
  pip3 install torch==${PYTORCH_VERSION} torchvision torchaudio --extra-index-url https://download.pytorch.org/whl/cu116
elif [[ "$CUDA_VERSION" == 'cu117' ]]; then
  pip3 install torch==${PYTORCH_VERSION} torchvision torchaudio --extra-index-url https://download.pytorch.org/whl/cu117
fi

pip install pyg-lib torch-scatter torch-sparse torch-cluster torch-spline-conv torch-geometric==${PYTORCH_GEOMETRIC_VERSION} -f https://data.pyg.org/whl/torch-${PYTORCH_VERSION}+${CUDA_VERSION}.html

pip install jupyter matplotlib seaborn sklearn
pip install pydgn==1.3.0.post1
pip install --upgrade ogb  # to remove warning

pip install uci-dataset unlzw3 requests zipfile openpyxl