# Code for the paper titled "High-Fidelity Audio Compression with Improved RVQGAN"

This directory contains code for the Neurips 2023 conference submission titled, "High-Fidelity Audio Compression with Improved RVQGAN". This code is submitted as part of the supplementary material.

The code is not readily executable due to a private python dependency, `audiotools`.
We plan to make a public release of this dependency in future.

## Directory Structure
```
   .
   |-codec  --> Pytorch code for proposed codec
   |   |---compare
   |   |---model
   |   |---nn
   |-conf   --> Configuration files for various settings
   |   |---ablations
   |   |---downsampling
   |   |---quantizer
   |   |---size
   |-scripts --> Useful scripts
```

Model code can be found in [codec/model/codec.py](codec/model/codec.py).

Training script: [scripts/train.py](scripts/train.py)

The scripts directory contains useful scripts for training and evaluating the
codec models. We also include scripts used to compute metrics reported in the
paper.
