## Environment Setup
``conda env create -f env.yaml``
torch 1.13 automatically install cuda11.7 library in the virtual env. It causes conflicts if the system already has a cudatoolkit installed in ``/usr/local/cuda``
A workaround is to add the sitepackage path to  ``LD_LIBRARY_PATH``. Do the following to automate the process when run ``conda activate fmri-movie``.

- ``cd`` to ``.../anaconda3/envs/fmri-movie/`` (where the virual env is installed)
- run the following
```sh
mkdir -p ./etc/conda/activate.d
mkdir -p ./etc/conda/deactivate.d
touch ./etc/conda/activate.d/env_vars.sh
touch ./etc/conda/deactivate.d/env_vars.sh
```

- put the following to ``activate.d/env_vars.sh``
```sh
#!/bin/sh
SCRIPT_DIR=$( python3 -c 'import sysconfig; print(sysconfig.get_paths()["purelib"])' )
CUDAPATH=$SCRIPT_DIR/nvidia/cublas/lib/
export LD_LIBRARY_PATH_ORIG=$LD_LIBRARY_PATH
export LD_LIBRARY_PATH=$CUDAPATH:$LD_LIBRARY_PATH
```

- put the following to ``deactivate.d/env_vars.sh``
```sh 
#!/bin/sh
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH_ORIG
unset LD_LIBRARY_PATH_ORIG
```
