#!/usr/bin/env python
import os.path
import shutil
from deeperwin.cli import main
from deeperwin.run_tools.geometry_database import load_geometries, load_datasets, Geometry
from deeperwin.configuration import Configuration
from deeperwin.checkpoints import load_run
import ruamel.yaml

# Settings
dry_run = False
dataset = "QM7_large_scale_exp_es"

checkpoint = "/gpfs/data/fs71573/scherbela/runs/checkpoints/foundation/midimol_2023-05-01_699torsion_nc_by_std_256k.zip"
phisnet_checkpoint = "/gpfs/data/fs71573/scherbela/runs/checkpoints/phisnet/phisnet_3LayerL2_47kGeoms_174Epochs.zip"

# Constants
reuse_config_fname = "config_reuse_template.yml"
calc_name = checkpoint.split("/")[-1].replace(".zip", "")
calc_dir = "reuse_large_scale_exp_" + calc_name

# Create directory for reusing from one specific checkpoint
if not os.path.isdir(calc_dir):
    os.mkdir(calc_dir)
os.chdir(calc_dir)

# Load model config from checkpoint and use it to replace the reuse model config
with open("../" + reuse_config_fname) as f:
    reuse_config = ruamel.yaml.YAML().load(f)
checkpoint_config = load_run(checkpoint, load_pkl=False, parse_config=False).config
reuse_config["model"] = checkpoint_config["model"]
reuse_config["reuse"]["path"] = checkpoint
reuse_config["reuse"]["path_phisnet"] = phisnet_checkpoint
reuse_config["experiment_name"] = calc_dir
#with open("config.yml", "w") as f:
#    ruamel.yaml.YAML().dump(reuse_config, f)

# Get all geometries for single points
all_geometries = load_geometries()
all_datasets = load_datasets()
if dataset in all_geometries:
    geometry_hashes = [dataset]
else:
    geometry_hashes = all_datasets[dataset].get_hashes()

# Submit the actual calculations
for geom_hash in geometry_hashes:
    geom = all_geometries[geom_hash]
    n_heavy = geom.n_heavy_atoms
    if n_heavy == 5:
        reuse_config["dispatch"]["queue"] = "a100"
    elif n_heavy == 6:
        reuse_config["dispatch"]["queue"] = "a100"
    elif n_heavy == 7:
        reuse_config["dispatch"]["queue"] = "a100"
    reuse_config["experiment_name"] = calc_dir

    # Write config and submit job
    with open("config.yml", "w") as f:
        ruamel.yaml.YAML().dump(reuse_config, f)
    print(f"Generating job for {geom_hash}")
    cmd = "setup -i config.yml"
    cmd += f" -p physical {geom_hash}"
    if dry_run:
        cmd += " --dry-run"
    main(cmd)
os.chdir("..")
  
