let _DEBUG = false;

async function main() {
    const jsPsych = initJsPsych({
        on_finish: () => {
            jsPsych.data.displayData();
        },
        show_progress_bar: true,
        auto_update_progress_bar: false,
    });

    let condition = "dkg";
    console.log(condition);
    let subject_id = jsPsych.data.getURLVariable("PROLIFIC_PID");
    let study_id = jsPsych.data.getURLVariable("STUDY_ID");
    let session_id = jsPsych.data.getURLVariable("SESSION_ID");

    jsPsych.data.addProperties({
        condition: condition,
        subject_id: subject_id,
        study_id: study_id,
        session_id: session_id,
    });

    let files = [
        "0_1-green.png",
        "0_1-orange.png",
        "0_2-green.png",
        "0_2-orange.png",
        "0_3-green.png",
        "0_3-orange.png",
        "0_4-green.png",
        "0_4-orange.png",
        "0_5-green.png",
        "0_5-orange.png",
        "0_6-green.png",
        "0_6-orange.png",
        "1_0-green.png",
        "1_0-orange.png",
        "1_1-green.png",
        "1_1-orange.png",
        "1_6-green.png",
        "1_6-orange.png",
        "1_7-green.png",
        "1_7-orange.png",
        "3_0-.png",
        "3_0-orange.png",
        "3_1-.png",
        "3_1-green.png",
        "3_1-orange.png",
        "3_2-.png",
        "3_2-green.png",
        "3_2-orange.png",
        "3_3-.png",
        "3_3-green.png",
        "3_3-orange.png",
        "3_4-.png",
        "3_4-green.png",
        "3_4-orange.png",
        "3_5-.png",
        "3_5-green.png",
        "3_5-orange.png",
        "3_6-.png",
        "3_6-green.png",
        "3_6-orange.png",
        "3_7-.png",
        "3_7-orange.png",
        "4_0-.png",
        "4_0-orange.png",
        "4_1-.png",
        "4_1-green.png",
        "4_1-orange.png",
        "4_2-.png",
        "4_2-green.png",
        "4_2-orange.png",
        "4_3-.png",
        "4_3-green.png",
        "4_3-orange.png",
        "5_0-.png",
        "5_1-.png",
        "5_1-green.png",
        "5_2-.png",
        "5_2-green.png",
        "5_3-.png",
        "5_3-green.png",
        "6_0-.png",
        "6_1-.png",
        "6_1-green.png",
        "6_2-.png",
        "6_2-green.png",
        "6_2-orange.png",
        "6_3-.png",
        "6_3-green.png",
        "7_0-.png",
        "7_1-.png",
        "7_1-green.png",
        "7_3-.png",
        "7_3-green.png",
    ];
    let stimuli = {}
    let dkg_cell = [
        {
            img: "assets/misc/3_7-green_dkgstarter.png",
            coords: [3, 7],
            keys: ["green"],
            count: 0,
        },
    ];
    stimuli.dkg = dkg_cell.concat(files.map((f) => {
        return {
            img: "assets/dkg/" + f,
            coords: f
                .split(".")[0]
                .split("_")
                .slice(0, 2)
                .map((x) => parseInt(x)),
            keys: f.split(".")[0].split("-")[1].split("_"),
            count: 0,
        };
    }));
    console.log(stimuli);
    // let stimuli = [{img: "dkg.png", coord: [0, 0]}];

    let n_trials = Object.values(stimuli).reduce((acc, e) => acc + e.length, 0);
    console.log(n_trials);

    console.log(stimuli);

    const consent = {
        type: jsPsychExternalHtml,
        url: "consent.html",
        cont_btn: "start",
        execute_script: !_DEBUG,
    };

    const welcomeMessage = {
        type: jsPsychHtmlButtonResponse,
        stimulus: "Welcome to the experiment! Press press the 'Next' button to begin.",
        choices: ["Next"],
    };

    const intro = {
        type: jsPsychInstructions,
        pages: [
            `
            <p>
            Welcome to the experiment!
            <br>
            <b>Note</b>: we will bonus you $0.05 for every correct answer you provide - for up to a bonus of $0.50.
            </p>
            `,
        ],
        show_clickable_nav: true,
    };

    let comprehension = {
        type: jsPsychExternalHtml,
        url: "",
        cont_btn: "start",
        execute_script: !_DEBUG,
    };

    // let preload = {
    //     type: jsPsychPreload,
    //     auto_preload: true,
    //     images: Object.values(stimuli).flatMap((domain) => {
    //         return domain.map((e) => e.img);
    //     }),
    //     video: ["assets/misc/grid_animation.mp4", "assets/misc/dkg_animation.mp4", "assets/misc/blocks_animation.mp4", "assets/misc/museum_animation.mp4"],
    // };

    let progress = 0;
    let grid_intro = {
        type: jsPsychConditionalInstructions,
        pages: [
            `
                <h1> Aliens and Gems </h1>
                <p>
                You will be presented with an image of an alien in a room with three gems: <b>red</b>, <b>blue</b>, and <b>green</b>.
                The alien got into the room by teleporting into a random spot.
                The alien wants to obtain one of the three gems.
                <br>
                Your task is to infer which gem the alien wants.
                At some point, a security camera takes a photo of the room.
                <br>
                The below video shows an example. In the video, the alien's goal is to obtain the red gem.
                </p>
                <video id="training-vid" src="assets/misc/grid_animation.mp4" style="width: 40%" controls></video>
                <br>
                <p>
                Here is the picture taken by the security camera:
                </p>
                <img src="assets/grid/1_0.png" style="width: 40%" />
                `,
            `
                <p>
                <br>
                You will be shown the picture taken by the security camera.
                From this picture, your task is to infer the gem that the alien wants.
                Remember, there are three possible gems that the alien could want: the red, blue, and green gem.
                <br>
                <b>Note:</b> the alien is completely familiar with the room, and knows the locations of all the gems from whatever position they
                are currently in, even if there are walls in the way.
                The alien can only move horizontally and vertically in the room, and not diagonally.

                <br><br>
                You will complete several trials, each with a different image of the alien in the room.
                </p>
                `,
        ],
        setup_fns: [
            () => {
                if (_DEBUG) {
                    return;
                }
                document.querySelector("#jspsych-instructions-next").disabled = true;
                let video = document.querySelector("#training-vid");
                video.addEventListener("ended", () => {
                    document.querySelector("#jspsych-instructions-next").disabled = false;
                });
            },
        ],
        show_clickable_nav: true,
    };
    let grid_comprehension = {
        type: jsPsychExternalHtml,
        url: "grid_comprehension.html",
        cont_btn: "start",
        execute_script: !_DEBUG,
    };
    let gridworld = {
        timeline: [
            {
                type: jsPsychHtmlMultiSliderResponse,
                stimulus: () => {
                    return `
                    The alien was teleported in onto a random location in the room, and is moving towards one of the three gems.<br><br>
                    The security camera took a picture of them in the following position. Which gem do you think the alien wants?
                    <br>
                    <br>
                    <img src=${jsPsych.timelineVariable("img")} />
                    <br>
                    You will need to touch each slider before proceeding to the next trial.
                    <br>
                    `;
                },
                require_movement: true,
                slider_width: 80,
                labels: () => {
                    let gem_width = 5;
                    return [
                        [
                            [
                                `Definitely not red gem <img src="assets/misc/red_gem.png" style="width:${gem_width}%" />`,
                                "Unsure",
                                `Definitely red gem <img src="assets/misc/red_gem.png" style="width:${gem_width}%" />`,
                            ],
                            [
                                `Definitely not blue gem <img src="assets/misc/blue_gem.png" style="width:${gem_width}%" />`,
                                "Unsure",
                                `Definitely blue gem <img src="assets/misc/blue_gem.png" style="width:${gem_width}%" />`,
                            ],
                            [
                                `Definitely not green gem <img src="assets/misc/green_gem.png" style="width:${gem_width}%" />`,
                                "Unsure",
                                `Definitely green gem <img src="assets/misc/green_gem.png" style="width:${gem_width}%" />`,
                            ],
                        ],
                    ];
                },
                prompts: ["<br>Which gem do you think the alien was headed towards?"],
                data: {
                    img: jsPsych.timelineVariable("img"),
                    coords: jsPsych.timelineVariable("coords"),
                    type: "grid",
                },
                on_finish: () => {
                    progress += 1 / n_trials;
                    jsPsych.setProgressBar(progress);
                },
            },
        ],
        timeline_variables: stimuli.grid,
    };

    // let dkg = {
    //     timeline: [
    //         {
    //             type: jsPsychHtmlButtonSliderResponse,
    //             stimulus: () => {
    //                 return `
    //                 The person woke up on one of the <b>white tiles</b> in the room, with either one, both, or none of the keys in their pocket.<br><br>
    //                 They was observed at the following position along their route. Which gem do you think the person wants and is headed towards?
    //                 <br>
    //                 <br>
    //                 <img src=${jsPsych.timelineVariable("img")} />
    //                 <br>
    //                 <br>
    //                 `;
    //             },
    //             require_movement: true,
    //             slider_width: 80,
    //             labels: ["Totally unsure", "Totally sure"],
    //             prompt: "<br>How confident are you in your prediction?",
    //             choices: ["Red Gem", "Blue Gem"],
    //             data: {
    //                 coords: jsPsych.timelineVariable("coords"),
    //                 keys: jsPsych.timelineVariable("keys"),
    //                 type: "doors_keys_gems",
    //             },
    //         },
    //     ],
    //     on_finish: () => {
    //         progress += 1 / n_trials;
    //         jsPsych.setProgressBar(progress);
    //     },
    //     timeline_variables: stimuli.dkg,
    // };
    let dkg_intro = {
        type: jsPsychConditionalInstructions,
        pages: [
            `
           <h1> Doors, Keys, and Gems </h1>
           <p>
           You will be presented with an image of an alien in a room.
           The alien got into the room by teleporting in.
           <br>
           The room has two gems: <b>red</b>, and <b>blue</b>.
           The alien wants to obtain one of the two gems, but the gems are located behind locked doors,
           which can only be opened by first picking up a key of the <b>same</b> color as the door.
           The alien only cares about the gem, and not which door it takes to get that gem.

           At some point, while the alien is obtaining the gem, a security camera takes a photo of the room.
           <br>
           The below video shows an example, where the alien is teleported in and obtains the blue gem - note that they had to first pick up the green key in order to unlock the green door.
           </p>
           <video id="training-vid" src="assets/misc/dkg_animation.mp4" style="width: 40%" controls></video>

           <p>
           Here is the picture taken by the security camera:
           </p>
           <img src="assets/dkg/3_4-green.png" style="width: 40%" />
           `,
            `
           <br><br>
           <p>
           You will be shown the picture taken by the security camera.
           From this image, your task is to infer the goal of the alien - the gem that the alien wants.
           Remember, there are two possible gems that can be obtained: the red gem, or the blue gem.
           <br><br>
           <b>Note:</b>The alien is always teleported in on a location <b>below the locked doors</b>, meaning that they always start out on a white tile, and not a gray tile.
           The alien can only move horizontally and vertically in the room, and not diagonally.
           <br>
           Also note that the alien is completely familiar with the room, and knows the locations of all doors, keys, and gems from whatever position they are currently in, even if there are walls in the way.
           <br>
           </p>
           `,
        ],
        setup_fns: [
            () => {
                if (_DEBUG) {
                    return;
                }
                document.querySelector("#jspsych-instructions-next").disabled = true;
                let video = document.querySelector("#training-vid");
                video.addEventListener("ended", () => {
                    document.querySelector("#jspsych-instructions-next").disabled = false;
                });
            },
        ],
        show_clickable_nav: true,
    };
    let dkg_comprehension = {
        type: jsPsychExternalHtml,
        url: "dkg_comprehension.html",
        cont_btn: "start",
        execute_script: !_DEBUG,
    };
    let dkg = {
        timeline: [
            {
                type: jsPsychHtmlMultiSliderResponse,
                stimulus: () => {
                    return `
                    The alien was teleported onto a random location in the room below the doors, and is attempting to reach one of the two gems.<br><br>
                    The security camera took the following picture. Which gem do you think the alien wants?
                    <br>
                    <br>
                    <img src=${jsPsych.timelineVariable("img")} />
                    <br>
                    You will need to touch each slider before proceeding to the next trial.
                    <br>
                    `;
                },
                require_movement: true,
                slider_width: 80,
                labels: [
                    [
                        [
                            `Definitely red gem <img src="assets/misc/red_gem.png" style="width:5%" />`,
                            "Unsure",
                            `Definitely blue gem <img src="assets/misc/blue_gem.png" style="width:5%" />`,
                        ],
                    ],
                ],
                prompts: [["<br>Is the alien headed towards the <b>red</b> gem or the <b>blue</b> gem?"]],
                data: {
                    img: jsPsych.timelineVariable("img"),
                    coords: jsPsych.timelineVariable("coords"),
                    keys: jsPsych.timelineVariable("keys"),
                    type: "doors_keys_gems",
                },
                on_finish: () => {
                    progress += 1 / n_trials;
                    jsPsych.setProgressBar(progress);
                },
            },
        ],
        timeline_variables: stimuli.dkg,
    };

    let blocks_intro = {
        type: jsPsychConditionalInstructions,
        pages: [
            `
            <h1> Blocks and Words </h1>
            <p>
            <br>
            A person walks into a room and sees some letter blocks piled randomly on a table.
            Then, they start re-arranging the blocks to spell a word.
            However, the person is interrupted by a fire alarm, and has to leave the room before they are able to finish spelling the word.

            In the example below, the person is stacking the blocks to spell the word “DIGGER.”
            </p>
            <video id="training-vid" src="assets/misc/blocks_animation.mp4" style="width: 40%" controls></video>

            <p>
            They left the blocks in the following configuration:
            </p>
            <img src="assets/misc/blocks_snapshot.png" style="width: 40%" />
            `,
            `
            <p>
            You will be shown an image of the blocks as they were left after the fire alarm went off.
            The fire alarm could have gone off at any time, including just after the person entered the room, but before they began to re-arrange the blocks.
            <br><br>

            Your task is to infer 1. what word the person is trying to spell, and 2. which blocks have been touched or moved by the person in doing so.
            </p>
            `,
        ],
        setup_fns: [
            () => {
                if (_DEBUG) {
                    return;
                }
                document.querySelector("#jspsych-instructions-next").disabled = true;
                let video = document.querySelector("#training-vid");
                video.addEventListener("ended", () => {
                    document.querySelector("#jspsych-instructions-next").disabled = false;
                });
            },
        ],
        show_clickable_nav: true,
    };
    let blocks_comprehension = {
        type: jsPsychExternalHtml,
        url: "blocks_comprehension.html",
        cont_btn: "start",
        execute_script: !_DEBUG,
    };
    let blocksword = {
        timeline: [
            {
                type: jsPsychHtmlMultiSliderResponse,
                stimulus: () => {
                    return `
                    The person entered the room with the blocks piled randomly on a table, and started rearranging them to spell a word.<br><br>
                    At some point, the fire alarm went off, and the person had to leave the room.
                    The blocks were left behind in the following configuration.
                    <br>
                    <br>
                    <img src=${jsPsych.timelineVariable("img")} style="width: 50%" />
                    <br>
                    You will need to touch each slider before proceeding to the next trial.
                    `;
                },
                n_questions: 2,
                require_movement: true,
                slider_width: 80,
                labels: [
                    [["Definitely spelling <b>digger</b>", "Unsure", "Definitely spelling <b>rigged</b>"]],
                    [["Definitely not touched", "Unsure", "Definitely touched"]],
                ],
                prompts: () => {
                    return [
                        "<br>1. Which word is the person trying to spell - <b>digger</b> or <b>rigged</b>?<br><br>",
                        `<br>2. We need to send some of these blocks back for forensic inspection of fingerprints.
                 In the below image, one of the blocks has been colored in red.
                 <br><br>
                 <img src="${jsPsych.timelineVariable("touch_img")}" style="width: 50%}"
                 <br><br>
                 How likely is it that the specified block in red was touched by the person?
                 `,
                    ];
                },
                data: {
                    img: jsPsych.timelineVariable("img"),
                    touch_img: jsPsych.timelineVariable("touch_img"),
                    blocks: jsPsych.timelineVariable("blocks"),
                    touch_coords: jsPsych.timelineVariable("touch_coords"),
                    touch_block: jsPsych.timelineVariable("touch_block"),
                    type: "blocksword",
                },
                on_finish: () => {
                    progress += 1 / n_trials;
                    jsPsych.setProgressBar(progress);
                },
            },
            // {
            //     type: jsPsychHtmlMultiButtonSliderResponse,
            //     stimulus: () => {
            //         return `
            //         The person woke up in the room with the blocks arranged in a totally random configuration, and started rearranging them to spell a word.<br><br>
            //         The blocks were observed in the following configuration.
            //         <br>
            //         <br>
            //         <img src=${jsPsych.timelineVariable("img")} style="width: 50%" />
            //         <br>
            //         `;
            //     },
            //     n_questions: 2,
            //     require_movement: true,
            //     slider_width: 80,
            //     labels: [
            //         ["Totally unsure", "Totally sure"],
            //         ["Definitely not touched", "Definitely touched"],
            //     ],
            //     prompts: () => {
            //         return [
            //             "<br>Which word is the person trying to spell - <b>digger</b> or <b>rigged</b>?<br><br>",
            //             `<br>We need to send some of these blocks back for forensic inspection of fingerprints.
            //      In the below image, one of the blocks has been colored in red.
            //      <br><br>
            //      <img src="${jsPsych.timelineVariable("touch_img")}" style="width: 50%}"
            //      <br><br>
            //      `,
            //         ];
            //     },
            //     slider_prompt: [
            //         "<br>How confident are you in your prediction?",
            //         `<br>How likely is it that the specified block in red was touched by the person?`,
            //     ],
            //     choices: [["digger", "rigged"]],
            //     data: {
            //         type: "blocksword",
            //     },
            // },
        ],
        timeline_variables: stimuli.blocksword,
    };

    let museum_intro = {
        type: jsPsychConditionalInstructions,
        pages: [
            `
           <h1> Museum </h1>
           <p>
           <br>
           The study takes place in a museum with two people: a <b>Thief</b> and a <b>Guard</b>.
           The Thief falls through the ceiling and lands in the museum, and then attempts to escape through one of the four exits located at the corners of the museum.
           Only one door leads to the exit, and the other three doors lead to dead ends.
           The thief knows which one is the real exit.
           The Guard aims to catch the thief.
           At some point, a security camera takes a picture of them.
           <br><br>

           While the guard is patrolling, the thief falls down through the ceiling onto a random position in the museum, and attempts to escape to the top right exit.
           In the video, the <b>blue person</b> is the thief, while the <b>red person</b> is the guard attempting to catch them.
           People will be marked with an arrow indicating the direction they are facing.

           </p>
           <video id="training-vid" src="assets/misc/museum_animation.mp4" style="width: 40%" controls></video>

           <p>
           Here is the picture taken by the security camera:
           </p>
           <img src="assets/misc/museum_snapshot.png" style="width: 40%" />
           `,
            `
           <p>
           You will be shown the picture taken by the security camera.
           Your task will be to 1. Determine who is the guard and who is the thief, and 2. Determine the thief's escape plan: which exit the thief is attempting to reach.
           <br>
           <b>Note:</b> both the thief and the guard are completely familiar with the museum, and know both where the exit and the other player are at all times, even if there are walls in the way.

           </p>
           `,
        ],
        setup_fns: [
            () => {
                if (_DEBUG) {
                    return;
                }
                document.querySelector("#jspsych-instructions-next").disabled = true;
                let video = document.querySelector("#training-vid");
                video.addEventListener("ended", () => {
                    document.querySelector("#jspsych-instructions-next").disabled = false;
                });
            },
        ],
        show_clickable_nav: true,
    };
    let museum_comprehension = {
        type: jsPsychExternalHtml,
        url: "museum_comprehension.html",
        cont_btn: "start",
        execute_script: !_DEBUG,
    };
    let museum = {
        timeline: [
            {
                type: jsPsychHtmlMultiSliderResponse,
                stimulus: () => {
                    return `
                    The thief loses their grip on the ceiling and drops down onto a random square in the museum, alerting the guard.
                    The two people were observed in the following positions. The arrows indicate the direction that they are currently facing.
                    <br>
                    <img src=${jsPsych.timelineVariable("img")} style='max-width:50%' />
                    <br>
                    You will need to touch each slider before proceeding to the next trial.
                    `;
                },
                require_movement: true,
                slider_width: 80,
                labels: () => {
                    let door_width = 8;
                    return [
                        [
                            [
                                "Definitely <img src='assets/misc/person1.png' style='width:15%' />",
                                "Unsure",
                                "Definitely <img src='assets/misc/person2.png' style='width:15%' />",
                            ],
                        ],
                        [
                            [
                                `Definitely not <img src='assets/misc/door1.png' style='width:${door_width}%' />`,
                                "Unsure",
                                `Definitely <img src='assets/misc/door1.png' style='width:${door_width}%' />`,
                            ],
                            [
                                `Definitely not <img src='assets/misc/door2.png' style='width:${door_width}%' />`,
                                "Unsure",
                                `Definitely <img src='assets/misc/door2.png' style='width:${door_width}%' />`,
                            ],
                            [
                                `Definitely not <img src='assets/misc/door3.png' style='width:${door_width}%' />`,
                                "Unsure",
                                `Definitely <img src='assets/misc/door3.png' style='width:${door_width}%' />`,
                            ],
                            [
                                `Definitely not <img src='assets/misc/door4.png' style='width:${door_width}%' />`,
                                "Unsure",
                                `Definitely <img src='assets/misc/door4.png' style='width:${door_width}%' />`,
                            ],
                        ],
                    ];
                },
                prompts: () => {
                    return [
                        ["1. Which person is the <b>guard</b>?<br><br>"],
                        [
                            `<br><br>2. Where is the thief trying to escape to?<br><br>
                    Remember, the guard and the thief were observed in the following position:
                    <br>
                    <img src=${jsPsych.timelineVariable("img")} style='max-width:50%' />`,
                        ],
                    ];
                },
                data: {
                    type: "museum",
                    img: jsPsych.timelineVariable("img"),
                    agent0_coords: jsPsych.timelineVariable("agent0_coords"),
                    agent1_coords: jsPsych.timelineVariable("agent1_coords"),
                    agent0_action: jsPsych.timelineVariable("agent0_action"),
                    agent1_action: jsPsych.timelineVariable("agent1_action"),
                },
                on_finish: () => {
                    progress += 1 / n_trials;
                    jsPsych.setProgressBar(progress);
                },
            },
        ],
        timeline_variables: stimuli.museum,
    };

    let debrief = {
        type: jsPsychSurveyText,
        preamble: `
    Thank you for participating in our study. We would appreciate if you took the time to answer several questions
    about your experience. Please note that your answers to these questions will not impact your payment in any way - we simply
    wanted to get a sense of how people approached the task. So please be honest!

    Once you press the 'Finish experiment' button,
    you will be directed back to the prolific in a few moments.
    `,
        questions: [
            {
                prompt: `On what percent of trials did you provide answers with little or no thought put into them
      (e.g. just providing an answer so you could move on to the next question)? Please enter a number.`,
            },
            {
                prompt: "Was there anything confusing or unclear about the study?",
            },
            { prompt: "Are there any additional comments you have for us?" },
        ],
        button_label: "Finish experiment",
        on_finish: () => {
            let data = jsPsych.data.get().ignore("internal_node_id");
            console.log(data);
            document.body.innerHTML = `<p> Please wait. You will be redirected back to Prolific in a few moments.
      </p> If not, please use the following completion code to ensure \
      compensation for this study: C19G1QQB`;
            fetch("/saveData", {
                method: "POST",
                headers: {
                    "Content-Type": "application/json",
                },
                body: JSON.stringify(data),
            }).then((res) => {
                console.log(res);
                if ((res.response = 200)) {
                    window.location.replace("https://app.prolific.co/submissions/complete?cc=C175YX2X");
                }
            });
        },
    };

    let parts;
    if (condition == "grid") {
        parts = [grid_intro, grid_comprehension, gridworld];
    } else if (condition == "dkg") {
        parts = [dkg_intro, dkg_comprehension, dkg];
    } else if (condition == "blocks") {
        parts = [blocks_intro, blocks_comprehension, blocksword];
    } else if (condition == "museum") {
        parts = [museum_intro, museum_comprehension, museum];
    }

    let timeline = [
        consent,
        // welcomeMessage,
        intro,
        // preload,
        ...parts,
        debrief,
    ];
    jsPsych.run(timeline);
    // console.log(jsPsych.data.get());
}

main().catch((err) => console.log(err));
