library(dplyr)

# set directory to source file location
current_path = rstudioapi::getActiveDocumentContext()$path 
setwd(dirname(current_path ))

source("evaluation.R")
source("fastLOOCV_EMRidgeSVD.R")
source("wrappers.R")


lambdass = list((10^seq(10, -10, length.out = 100)),
                (10^seq(10, -10, length.out = 100)))

fLOO = rep("fastLOO", length(lambdass)-1)
mypath <- getwd()

## abalone
abalone = read.csv(paste0(dirname(mypath), "/Datasets/abalone.csv"))
abalone$V1 = as.factor(abalone$V1)

abalone.results = real.data.cv.test(abalone, "V9", "gaussian", 0.7, 100, c("fastLOO", "fastLOO.bign", "glmnet.ridge.10.fold","fastLOO.glm.bign","tau2","tau2.bign"), 
                                    lambdas = lambdass, seed = 123, e = 1e-8)

abalone.resultsINT = real.data.cv.test(abalone, "V9", "gaussian", 0.7, 100,  c("fastLOO", "fastLOO.bign", "glmnet.ridge.10.fold","fastLOO.glm.bign", "tau2","tau2.bign"),
                                       lambdas = lambdass, seed = 123, 
                                       use.interactions2 = T, use.squares = T, e = 1e-6)

#--------------------------------------------------------------------------
## airfoil

airfoil = read.csv(paste0(dirname(mypath), "/Datasets/airfoil.csv"))

airfoil.results = real.data.cv.test(airfoil, "V6", "gaussian", 0.7, 100, c("fastLOO", "fastLOO.bign", "glmnet.ridge.10.fold","fastLOO.glm.bign", "tau2","tau2.bign"), 
                                    lambdas = lambdass, seed = 123, e = 1e-6)


#--------------------------------------------------------------------------
## autompg
autompg = read.csv(paste0(dirname(mypath), "/Datasets/autompg.csv"))

autompg.results = real.data.cv.test(autompg, "mpg", "gaussian", 0.7, 100, c("fastLOO", "fastLOO.bign", "glmnet.ridge.10.fold","fastLOO.glm.bign", "tau2","tau2.bign"), 
                                    lambdas = lambdass, seed = 123, e = 1e-6)
