import os
from typing import Callable, Optional, Tuple

from .malware import MalwareFolder
from .utils import BinaryLoader


class BinaryDataset(MalwareFolder):
    def __init__(
        self,
        root: str,
        extensions: Optional[Tuple[str, ...]] = None,
        transform: Optional[Callable] = None,
        target_transform: Optional[Callable] = None,
        transforms: Optional[Callable] = None,
        is_valid_file: Optional[Callable[[str], bool]] = None,
        cache_size: int = 100,
    ) -> None:
        if extensions is None and is_valid_file is None:
            extensions = (".exe", ".dll", ".bytes", "")
        super().__init__(
            root,
            BinaryLoader(cache_size=cache_size),
            extensions=extensions,
            transform=transform,
            target_transform=target_transform,
            transforms=transforms,
            is_valid_file=is_valid_file,
            get_metadata_path=get_metadata_path,
        )

def get_metadata_path(path: str) -> str:
    metadata_path = os.path.abspath(path) + '.meta'
    if os.path.exists(metadata_path):
        return metadata_path
    else:
        return None
