# Disentangling Cognitive Diagnosis with Limited Exercise Labels

## Install

1. install pytorch from pytorch official site. The version used in our project is torch==1.12.1+cu116

2. install other packages
    ```
    pip install -r requirements.txt
    ```

## Run DisenCD

### Matmat

1. 100% Q-matrix
    
    ```
    python src/main.py --cls ENTRY_EDUVAE_FOLD -f DisenCD -dt Matmat --data_cfg.Q_delete_ratio 0.0 --model_cfg.lambda_q 15.0 --model_cfg.g_beta_user 0.5 --model_cfg.g_beta_item 0.5 
    ```
2. 20% Q-matrix
    ```
    python src/main.py --cls ENTRY_EDUVAE_FOLD -f DisenCD -dt Matmat --data_cfg.Q_delete_ratio 0.8
    ```
3. 10% Q-matrix
    ```
    python src/main.py --cls ENTRY_EDUVAE_FOLD -f DisenCD -dt Matmat --data_cfg.Q_delete_ratio 0.9
    ```

### JunYi

1. 100% Q-matrix
    ```
    python src/main.py --cls ENTRY_EDUVAE_FOLD -f DisenCD -dt JunYi --data_cfg.Q_delete_ratio 0.0 --model_cfg.lambda_q 10.0 
    ```
2. 20% Q-matrix
    ```
    python src/main.py --cls ENTRY_EDUVAE_FOLD -f DisenCD -dt JunYi --data_cfg.Q_delete_ratio 0.8
    ```
3. 10% Q-matrix
    ```
    python src/main.py --cls ENTRY_EDUVAE_FOLD -f DisenCD -dt JunYi --data_cfg.Q_delete_ratio 0.9
    ```

## Run Baselines

Take model=`NCDM`, dataset=`Matmat`, missing_ratio=`0.2` as an example.

```
python src/main.py --cls ENTRY_EDUVAE_FOLD -f NCDM -dt Matmat --data_cfg.Q_delete_ratio 0.8
```

