#!/bin/bash

devices=3

CUDA_VISIBLE_DEVICES=$devices python -u ./train_continual_baseline.py \
--task_path ./data/task_splits/combine1/task_{}/{} \
--plm_model ../../../resources/grappa \
--baseline_name ft \
--frozen_mode tuning_plm \
--max_seq_length 300 \
--encoder_dim 1024 \
--max_patience 30 \
--seed 23 \
--cuda \
--lr 2e-4 \
--epoch_eval 55 \
--epoch 60 \
--task_num 11 \
--beam_size 5 \
--batch_size 1 \
--accumulation_step 32 \
--combine_K 5 \
--column_pointer \
--few_shot -1 \
--device $devices


#3,1,0,4,5,9,2,10,7,8,6
#../train/data_train/combine_context_4.0_mix_perm_1/
#[[5, 2, 3, 1, 7], [8], [4], [9], [6], [10], [0]]
#../train/data_train/combine_context_4.0_mix_perm_2/
#[[7, 3, 1, 2, 5], [8], [0], [9], [6], [10], [4]]
#../train/data_train/combine_context_4.0_mix_perm_3/
#[[3, 7, 0, 6, 5], [8], [4], [10], [2], [9], [1]]
#../train/data_train/combine_context_4.0_mix_perm_4/
#[[4, 5, 2, 1, 6], [9], [7], [10], [3], [8], [0]]
#../train/data_train/combine_context_4.0_mix_perm_5/