<br />
<p align="center">
  <img src="figs/logo.png" align="center" width="42%">
  
  <h3 align="center"><strong>Unsupervised Video Domain Adaptation for Action Recognition: A Disentanglement Perspective</strong></h3>

  <p align="center">
      Anonymous Authors
  </p>
</p>


## About
**TranSVAE** is a disentanglement framework designed for **unsupervised video domain adaptation**. It aims at disentangling the domain information from the data during the adaptation process. We consider the generation of cross-domain videos from two sets of **latent factors**: one encoding the static **domain-related** information and another encoding the **temporal and semantic-related** information. Objectives are enforced to constrain these latent factors to achieve domain disentanglement and transfer.

<br>
<p align="center">
  <img src="figs/example.gif" align="center" width="60%">
  <br>
  <strong>Col1:</strong> Original sequences ("Human" $\mathcal{D}=\mathbf{P}_1$ and "Alien" $\mathcal{D}=\mathbf{P}_2$); <strong>Col2:</strong> Sequence reconstructions; <strong>Col3:</strong> Reconstructed sequences using $z_1^{\mathcal{D}},...,z_T^{\mathcal{D}}$; <strong>Col4:</strong> Domain transferred sequences with exchanged $z_d^{\mathcal{D}}$.
</p>
<br>


## Outline

- [Installation](#installation)
- [Data Preparation](#data-preparation)
- [Getting Started](#getting-started)


## Installation

Please refer to [docs/INSTALL.md](docs/INSTALL.md) for the installation details.


## Data Preparation

Please refer to [docs/DATA_PREPARE.md](docs/DATA_PREPARE.md) for the details to prepare the <sup>1</sup>[UCF<sub>101</sub>](https://www.crcv.ucf.edu/data/UCF101.php), <sup>2</sup>[HMDB<sub>51</sub>](https://serre-lab.clps.brown.edu/resource/hmdb-a-large-human-motion-database), <sup>3</sup>[Jester](https://20bn.com/datasets/jester), <sup>4</sup>[Epic-Kitchens](https://epic-kitchens.github.io/2021), and <sup>5</sup>[Sprites](https://github.com/YingzhenLi/Sprites) datasets.


## Getting Started

After setting all necessary packages and libraries, you can now run experiments by the following scripts:

### HMDB2UCF
```shell
sh exp/train_script_I3D_hmdb2ucf.sh
```

### UCF2HMDB
```shell
sh exp/train_script_I3D_ucf2hmdb.sh
```

### Jester
```shell
sh exp/train_script_I3D_jester.sh
```

We have set a fixed random seed and the optimal hyperparameters for all experiments, so that the reported scores are directly reproducible.

If you prefer to use Jupyter Notebook, you can find an example in ``exp/TransVAE_I3D_hmdb-ucf.ipynb``.