EXP_NAME=$1
OPTIM=$2
if [ "$OPTIM" = "lpmm" ]; then
    OPTIMARGS="--customized_optim lpmm "
elif [ "$OPTIM" = "bnb" ]; then
    OPTIMARGS="--optim adamw_bnb_8bit "
else
    OPTIMARGS="--optim adamw_torch "
fi

torchrun --nproc_per_node=2 --master_port=20001 train.py \
    --model_name_or_path decapoda-research/llama-7b-hf \
    --data_path ./alpaca_data.json \
    --bf16 True \
    --output_dir $EXP_NAME \
    --num_train_epochs 3 \
    --per_device_train_batch_size 2 \
    --per_device_eval_batch_size 1 \
    --gradient_accumulation_steps 32  \
    --evaluation_strategy "no" \
    --save_strategy "steps" \
    --save_steps 2000 \
    --save_total_limit 1 \
    --learning_rate 2e-5 \
    --weight_decay 0. \
    --warmup_ratio 0.03 \
    --lr_scheduler_type "cosine" \
    --logging_steps 1 \
    --fsdp "full_shard auto_wrap" \
    --fsdp_transformer_layer_cls_to_wrap 'LlamaDecoderLayer' \
    $OPTIMARGS \
    --skip_memory_metrics False \
    --tf32 True
