# See experiments folder for specific implementations
struct StabilizedNDE{A,B,C,D}
    f::A
    g::B
    F::C
    γ::D
end

function (snde::StabilizedNDE)(u, θ, t)
    (; f, g, F, γ) = snde
    return f(u, θ, t) .- γ * F(u, t) * g(u, t)
end

function (snde::StabilizedNDE)(du, u, θ, t)
    (; f, g, F, γ) = snde
    f(du, u, θ, t)
    du .-= γ * F(u, t) * g(u, t)
    return nothing
end
