# Low Tensor Rank Learning of Neural Dynamics

## Requirements 

To install the requirements:

``pip install -r requirements.txt``

In particular, the code was tested with Python `3.11.2`.

## Running the code

### LtrRNN

The `rnn_validation` folder contains the code for section 4 (neural data) and 5 (task-trained RNN). The code can be used to fit ltrRNN to neural (or RNN) data.

- We have provided a pre-trained task-trained RNN model, along with the weights and activity as a result of motor perturbation learning.
To fit an ltrRNN to the activity of this task-trained RNN, simply run `fit_data.py`. 
It should take under an hour to fit with a GPU (see table 2, supplementary material A).

### Task-trained RNN
- You may train an RNN on the motor task we describe in the text by running `perturbation.py`. 
- To retrain it on the motor perturbation learning task , simply set `perturb=True` in `perturbation_parameters.yaml`.
- To fit an ltrRNN to it, simply change the folder to that of this task-trained RNN in the ltrRNN ``parameters.yaml``.

### Try your own data
This .zip was made for the purpose of review, and a high-level API to run our method on relatively arbitrary neural data will be provided upon publication.
Nevertheless, you may try our method on your own data with the present code by simply reimplementing `import_data.py`, making sure it returns the correct variables.

### Rank of the gradient w.r.t weights

The `rank_gradient` folder contains the code for section 6: the singular values of weight gradients in random RNNs.

You may simply run `main.py`. 
The `parameters` can be modified to try various activation functions, initial weight strength, input/output/RNN dimensions. 
With the default parameters, the code will take under an hour to run with a GPU.

